//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef ENUMERATIONTYPE_HH
#define ENUMERATIONTYPE_HH

#include "tyvis/TypeInfo.hh"
#include "tyvis/ScalarType.hh"

class IntegerType;
class ArrayType;
extern EnumerationTypeInfo SavantcharacterType_info;

class EnumerationType: public ScalarType {
public:
  EnumerationType() : ScalarType() {}
  EnumerationType(const EnumerationType&);

  EnumerationType( ObjectBase::ObjectType,
		   const TypeInfo& = SavantcharacterType_info );

  EnumerationType( ObjectBase::ObjectType,
		   const UniversalInteger &,
		   const TypeInfo & = SavantcharacterType_info);
  EnumerationType(ObjectBase::ObjectType, const IntegerType&,
		  const TypeInfo & = SavantcharacterType_info);
  EnumerationType(ObjectBase::ObjectType, const EnumerationType &,
		  const TypeInfo & = SavantcharacterType_info);
  EnumerationType(const EnumerationType&, const TypeInfo &);
  EnumerationType(bool, const EnumerationType&, const TypeInfo & = SavantcharacterType_info);
  
  virtual ~EnumerationType();
  
  EnumerationType& operator = (const EnumerationType&);
  
  Type get_kind() const;
  virtual const VHDLData &leftValue();

  const EnumerationType &vhdlAnd( const EnumerationType &rhs ) const;
  const EnumerationType &vhdlNot() const;
  const EnumerationType &vhdlOr( const EnumerationType & ) const;
  const EnumerationType &vhdlNand( const EnumerationType & ) const;
  const EnumerationType &vhdlNor( const EnumerationType & ) const;
  const EnumerationType &vhdlXor( const EnumerationType & ) const;
  const EnumerationType &vhdlXnor( const EnumerationType & ) const;
  
  // The attributes of Enumeration Types
  
  static EnumerationType  LEFT (const TypeInfo&);
  static EnumerationType  RIGHT(const TypeInfo&);
  static EnumerationType  HIGH (const TypeInfo&);
  static EnumerationType  LOW  (const TypeInfo&);
  static EnumerationType  ASCENDING (const TypeInfo&);
  static EnumerationType  SUCC      (const EnumerationType&);
  static EnumerationType  PRED      (const EnumerationType&);
  static EnumerationType  LEFTOF    (const EnumerationType&);
  static EnumerationType  RIGHTOF   (const EnumerationType&);
  static ArrayType        IMAGE     (const EnumerationType&); 
  static EnumerationType  VALUE     (const ArrayType&, const TypeInfo&);
  static IntegerType      POS       (const EnumerationType&, const TypeInfo&);
  static IntegerType      POS       (const EnumerationType&);
  static EnumerationType  VAL       (const IntegerType&, const TypeInfo&);

  static const EnumerationType &getEnumerationZero();
  static const EnumerationType &getEnumerationOne();
  static const EnumerationType &getEnumerationTrue();
  static const EnumerationType &getEnumerationFalse();

  static const EnumerationType &toBoolean( bool toConvert );

  TypeInfo &getTypeInfo() const;

private:
  EnumerationTypeInfo typeInfo;
};

extern ostream& operator<<(ostream &, const EnumerationType &);

#endif

