#include "DefaultAttributes.hh"
#include "STDTypes.hh"

DefaultAttributes::DefaultAttributes() {
  event = false;
  active = false;
  last_event = UniversalLongLongInteger::getMax();
  last_active = UniversalLongLongInteger::getMax();
  last_value.inttype = 0;
}

DefaultAttributes::DefaultAttributes(const DefaultAttributes& val) {
  event = val.event;
  active = val.active;
  last_event = val.last_event;
  sigtype = val.sigtype;
  last_active = val.last_active;
  switch(sigtype) {
  case VHDLData::UNIVERSAL_INTEGER:
    last_value.inttype = val.last_value.inttype;
    break;
  case VHDLData::UNIVERSAL_REAL:
    last_value.floattype = val.last_value.floattype;
    break;
  case VHDLData::UNIVERSAL_BOOLEAN:
    last_value.inttype = val.last_value.inttype;
    break;
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    last_value.physicaltype = val.last_value.physicaltype;
    break;
  default:
    break;
  }
}


DefaultAttributes&
DefaultAttributes::operator=(const DefaultAttributes& val) {
  event = val.event;
  active = val.active;
  last_event = val.last_event;
  sigtype = val.sigtype;
  last_active = val.last_active;
  switch(sigtype) {
  case VHDLData::UNIVERSAL_INTEGER:
    last_value.inttype = val.last_value.inttype;
    break;
  case VHDLData::UNIVERSAL_REAL:
    last_value.floattype = val.last_value.floattype;
    break;
  case VHDLData::UNIVERSAL_BOOLEAN:
    last_value.inttype = val.last_value.inttype;
    break;
  case VHDLData::UNIVERSAL_LONG_LONG_INTEGER:
    last_value.physicaltype = val.last_value.physicaltype;
    break;
  default:
    break;
  }
  return *this;
}
