#include "vhdl.hh"
#include "VHDLApplication.hh"
#include "VHDLKernel.hh"
#include "Hierarchy.hh"
#include <clutils/StringHashMap.h>
#include <warped/PartitionInfo.h>
#include <warped/RoundRobinPartitioner.h>
#include <cstring>
#include <fstream>
#include <cstdlib>
#include "_savant_entity_elab.hh"

using std::flush;

extern vector<VHDLKernel*> listOfProcesses;
// extern _savant_entity_elab *design;
Hierarchy * hier;


VHDLApplication::VHDLApplication( _savant_entity_elab *initDesign ) : design( initDesign ){
  ASSERT( design != 0 );
}


int
VHDLApplication::initialize( vector<string> & ){
  cout << "Elaborating design..." << flush;
  hier = new Hierarchy;
  design->instantiate(hier);
  design->connect(0, 0);
  // XXX cfmd debug line  hier->fdump(stdout, 0);
  cout << "Done.\n";

  return 0;
}

int
VHDLApplication::getNumberOfSimulationObjects(int) const {
  return VHDLKernel::getGlobalObjectId();
}

const PartitionInfo *
VHDLApplication::getPartitionInfo( unsigned int numProcessorsAvailable ){
  const PartitionInfo *retval = 0;

  Partitioner *myPartitioner = new RoundRobinPartitioner;
  retval = myPartitioner->partition( (vector<SimulationObject *> *)&listOfProcesses, 
				     numProcessorsAvailable );
  delete myPartitioner;


  return retval;
}

void
VHDLApplication::registerDeserializers(){
  registerTyvisDeserializers();
}

int
VHDLApplication::finalize()  {
  delete design;
  return 0;
}

string 
VHDLApplication::getCommandLineParameters() const { return ""; }
