#ifndef UNIVERSAL_INTEGER_HH
#define UNIVERSAL_INTEGER_HH

#include "tyvis/VHDLData.hh"
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include <iostream>
using std::cout;

class UniversalReal;
class AccessVariable;

class UniversalInteger : public VHDLData {
public:
  static const UniversalInteger &getMax();
  static const UniversalInteger &getMin();

  virtual VHDLData::UniversalType getUniversalKind() const{
    return UNIVERSAL_INTEGER;
  }

  UniversalInteger() { val = 0; overflow_flag = false; }
  UniversalInteger(int i) { val = i; overflow_flag = false; }
  UniversalInteger(LONG i) { val = i; overflow_flag = false; }
  UniversalInteger(char c) { val = c - '0'; overflow_flag = false; }
  UniversalInteger(bool b) {val = (true == b ? 1 : 0); overflow_flag = false; }
  UniversalInteger(double f) {val = (LONG) f; overflow_flag = false; }

  UniversalInteger(const VHDLData& v);

//   UniversalInteger(UniversalBoolean& value) {
//     val = (int) value;
//   }

  UniversalInteger(const UniversalInteger &i) : VHDLData(),
						val( i.val ),
						overflow_flag( false ){}

  ~UniversalInteger(){}
  UniversalInteger(const UniversalReal&);

  VHDLData& operator=(const VHDLData &);
  UniversalInteger& operator=(const UniversalInteger &);

  operator int() const { return val; }

  bool operator==( const RValue &compareTo ) const {
    return (getIntValue() == compareTo.getIntValue());
  }
  bool operator!=( const RValue &compareTo ) const {
    return (getIntValue() != compareTo.getIntValue());
  }

  bool operator > ( const RValue &compareTo ) const{
    return (getIntValue() > compareTo.getIntValue());
  }

  bool operator >= ( const RValue &compareTo ) const {
    return (getIntValue() >= compareTo.getIntValue());
  }

  bool operator < ( const RValue &compareTo ) const {
    return (getIntValue() < compareTo.getIntValue());
  }

  bool operator <= ( const RValue &compareTo ) const {
    return (getIntValue() <= compareTo.getIntValue());
  }

  UniversalInteger assign(char ch) {
    val = ch - '0';
    return val;
  }

  UniversalInteger& increment(void) {
    int oldval = val;
    val++;

    if (val < oldval) {
      overflow_flag = true;
    }
    else {
      overflow_flag = false;
    }

    return *this;
  }

  UniversalInteger& decrement(void) {
    int oldval = val;
    val--;

    if (val > oldval) {
      overflow_flag = true;
    }
    else {
      overflow_flag = false;
    }
    
    return *this;
  }

  bool overflow() const { return overflow_flag; }
  
  int savantwrite( AccessVariable &) const;
  int savantwrite( AccessType & ) const;
  int savantread( AccessVariable &);
  int savantread( AccessType & );
  int savantread(char *) {
    return NORMAL_RETURN;
  }
  int savantwrite( ostringstream &os ) const {
    os << this->val;
    return NORMAL_RETURN;
  }
  
  VHDLData *clone() const {
    return new UniversalInteger(*this);
  }
  
  void print(ostream& os = cout) const { os << getIntValue(); }

  static UniversalInteger typeCast(VHDLData& toCast);

  static const string &getUniversalIntegerType(){
    static const string universalIntegerType = "UniversalInteger";
    return universalIntegerType;
  }

  const string &getDataType() const {
    return getUniversalIntegerType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new UniversalInteger( si->getInt() );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getUniversalIntegerType(),
							   &UniversalInteger::deserialize );
  }

  int getValue() const { return val; }
  int getIntValue() const { return getValue(); }
  LONG getInt64Value() const { return (LONG)getValue(); }
  double getDoubleValue() const { return (double)getValue(); }

  UniversalInteger vhdlUnaryPlus() const;
  UniversalInteger vhdlUnaryMinus() const;
  UniversalInteger vhdlAbs() const;

  UniversalInteger vhdlPlus( const RValue & ) const;
  UniversalInteger vhdlMinus( const RValue & ) const;
  UniversalInteger vhdlMultiply( const RValue & ) const;
  UniversalInteger vhdlDivide( const RValue & ) const;
  UniversalInteger vhdlMod( const RValue & ) const;
  UniversalInteger vhdlRem( const RValue & ) const;
  UniversalInteger vhdlPow( const RValue & ) const;

  UniversalInteger vhdlNot() const;
  UniversalInteger vhdlAnd( const UniversalInteger & ) const;
  UniversalInteger vhdlOr( const UniversalInteger & ) const;
  UniversalInteger vhdlNand( const UniversalInteger & ) const;
  UniversalInteger vhdlNor( const UniversalInteger & ) const;
  UniversalInteger vhdlXor( const UniversalInteger & ) const;
  UniversalInteger vhdlXnor( const UniversalInteger & ) const;

private:
  int val;
  bool overflow_flag;
};

extern const UniversalInteger UNIVERSAL_TRUE;
extern const UniversalInteger UNIVERSAL_FALSE;


typedef UniversalInteger savantBit;

inline 
ostream &
operator<<( ostream& os, const UniversalInteger &i ) {
  os << i.getValue();
  return os;
}



#endif
