/* animated.cc
   Use to create new .cc project files

   Copyright (C) 2000  Mathias Broxvall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "general.h"
#include "animated.h"
#include "game.h"
#include "map.h"

using namespace std;

Animated::Animated() :GameHook() {
  Game::current->add(this);
  for(int i=0;i<3;i++) {
    specularColor[i] = 0.0;
    primaryColor[i] = 0.8;
    secondaryColor[i] = 0.3;
  }
  specularColor[3]=primaryColor[3]=secondaryColor[3]=1.0;
  texture= 0;  // GLuint. 0, not -1
}
Animated::~Animated() {
}
void Animated::has_moved() {
  position[2] = Game::current->map->getHeight(position[0],position[2]);
}
void Animated::onRemove() {
  GameHook::onRemove();
  Game::current->remove(this);    
}
void Animated::draw() {}
void Animated::draw2() {}
