namespace eval gui {
    variable gui

    # Define the fonts used for the Widget labels.
    switch $tkWorld(ostype) {
	windows {
	    set gui(font.label) {helvetica 10 bold}
	}
	default {
	    set gui(font.label) {helvetica 12 bold}
	}
    }
}

# gui::create --
#
#   Method to build the application's GUI components
#
# Args
#
#   None
#
# Returns
#
#   None

proc gui::create { } {
    global tkWorld
    variable gui

    # Create the toolbar.
    set tkWorld(toolbar) [toolbar::create .toolbar]

    # Create the shellbar.
    set tkWorld(shellbar) [shellbar::create .shellbar]

    # Create the Registry frame and load the component elements.
    set tkWorld(reg_listbox) [registry::interior \
	    [registry::create .registry]]
    registry::load

    # Now create the paned window frame for the Command Center
    # and Log Window
    set pw [panedwindow::create .pw 575 500]

    # Build the Command Center in the top pane.
    set f [frame $pw.pane1.cmd_center \
  	    -relief flat]
    label $f.label \
  	    -text "Command Center"
    scrollbar $f.yscrollbar \
  	    -command "$f.text yview" \
  	    -orient vertical \
	    -width 12
    scrollbar $f.xscrollbar \
  	    -command "$f.text xview" \
  	    -orient horizontal \
	    -width 12
    set tkWorld(cmd_center) [text $f.text \
  	    -wrap none \
  	    -width 70 \
  	    -height 10 \
	    -background #ffffff \
  	    -yscrollcommand [list $f.yscrollbar set] \
  	    -xscrollcommand [list $f.xscrollbar set]]
    grid $f.label - \
  	    -row 0 \
  	    -sticky ew \
  	    -padx 0 \
  	    -pady 0
    grid $f.text $f.yscrollbar \
  	    -row 1 \
  	    -sticky news \
  	    -padx 0 \
  	    -pady 0
    grid $f.xscrollbar \
  	    -row 2 \
  	    -sticky ew \
  	    -padx 0 \
  	    -pady 0
    grid [frame $f.pad1 -height 1] \
	    -row 3 \
	    -sticky ew \
	    -padx 0 \
	    -pady 1
    grid rowconfigure $f 1 -weight 1
    grid columnconfigure $f 0 -weight 1
    
    pack $pw.pane1.cmd_center \
	    -expand yes \
	    -fill both \
	    -padx 0 \
	    -pady 0

    # Build the Log Window in the bottom pane.
    set f [frame $pw.pane2.log_window \
  	    -relief flat]
    label $f.label \
  	    -text "Log Window"
    scrollbar $f.yscrollbar \
  	    -command "$f.text yview" \
  	    -orient vertical \
	    -width 12
    scrollbar $f.xscrollbar \
  	    -command "$f.text xview" \
  	    -orient horizontal \
	    -width 12
    set tkWorld(log_window) [text $f.text \
  	    -wrap none \
  	    -width 70 \
  	    -height 30 \
	    -background #ffffff \
  	    -yscrollcommand [list $f.yscrollbar set] \
  	    -xscrollcommand [list $f.xscrollbar set]]
    grid $f.label - \
  	    -row 0 \
  	    -sticky ew \
  	    -padx 0 \
  	    -pady 0
    grid $f.text $f.yscrollbar \
  	    -row 1 \
  	    -sticky news \
  	    -padx 0 \
  	    -pady 0
    grid $f.xscrollbar \
  	    -row 2 \
  	    -sticky ew \
  	    -padx 0 \
  	    -pady 0
    grid rowconfigure $f 1 -weight 1
    grid columnconfigure $f 0 -weight 1
    
    pack $pw.pane2.log_window \
	    -expand yes \
	    -fill both \
	    -padx 2 \
	    -pady 2

    # Create the menubar.
    set tkWorld(menubar) [menubar::create .menubar]

    grid .toolbar \
	    -row 1 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid [set tkWorld(seperator_1) [seperator::create .s1]] \
	    -row 2 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid .shellbar \
	    -row 3 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid [seperator::create .s2] \
	    -row 4 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid .registry \
	    -row 5 \
	    -column 0 \
	    -sticky news \
	    -padx 0 \
	    -pady 0
    grid [seperator::create .s3] \
	    -row 5 \
	    -column 1 \
	    -sticky ns \
	    -padx 0 \
	    -pady 0
    grid .pw \
	    -row 5 \
	    -column 2 \
	    -sticky news \
	    -padx 0 \
	    -pady 0

    # Configure the rows accordingly.
    for {set i 1} { $i < 5} {incr i} {
	grid rowconfigure . $i \
		-weight 0
    }
    grid rowconfigure . 5 \
	    -weight 1

    # Configure the columns to expand accordingly.
    grid columnconfigure . 0 \
	    -weight 0
    grid columnconfigure . 1 \
	    -weight 0
    grid columnconfigure . 2 \
	    -weight 1

    # Put the user at the CC.
    focus $tkWorld(cmd_center)

    # If the user clicks into these LW and CC widgets, activate the
    # toolbar button group associated with that widget.
    bind $tkWorld(cmd_center) <FocusIn> \
	    {toolbar::group_state cmd_center active; \
	    toolbar::button_state $toolbar::toolbar(stop) disabled}
    bind $tkWorld(log_window) <FocusIn> \
	    {toolbar::group_state log_window active}

    # Setup keyboard bindings for all of the commands available
    # in the CC.
    #
    # Stop
    bind $tkWorld(cmd_center) <Control-z> cmd_center::stop

    # Run
    bind $tkWorld(cmd_center) <Control-x> cmd_center::run
    bind $tkWorld(cmd_center) <Key-Return> {cmd_center::run; break}

    # Insert a physical carriage return in the script.
    bind $tkWorld(cmd_center) <Alt-Return> \
	    [list $tkWorld(cmd_center) insert {insert lineend} {}]

    # Clear the CC.
    bind $tkWorld(cmd_center) <Control-c> cmd_center::reset

    # Save the script.
    bind $tkWorld(cmd_center) <Control-s> cmd_center::shell

    # Display previous command.
    bind $tkWorld(cmd_center) <Control-p> {history::get end}
    bind $tkWorld(cmd_center) <Key-Up> {history::get end; break}

    # Remove previous command.
    bind $tkWorld(cmd_center) <Key-Down> \
	    [list $tkWorld(cmd_center) delete 0.0 end]

    # Display the command history.
    bind $tkWorld(cmd_center) <Control-m> history::create

    # Display the filename completion popup.
    bind $tkWorld(cmd_center) <Key-Tab> {wdir::expand::filename; break}

    # Jump windows between CC and LW.
    bind $tkWorld(cmd_center) <Control-j> \
	    [list focus $tkWorld(log_window)]

    # Setup keyboard bindings for all of the commands available
    # in the LW.
    #
    # Page up.
    bind $tkWorld(log_window) <Escape> log_window::up

    # Page Down.
    bind $tkWorld(log_window) <Control-v> log_window::down

    # Clear the CC.
    bind $tkWorld(log_window) <Control-c> log_window::clear

    # Save the contents to a file.
    bind $tkWorld(log_window) <Control-s> log_window::save

    # Jump window between CC and LW.
    bind $tkWorld(log_window) <Control-j> \
	    [list focus $tkWorld(cmd_center)]

    # Configure the window manager for unix systems.
    switch $tkWorld(ostype) {
	unix {
	    wm title . "tkWorld User: $tkWorld(user)"
	    wm iconbitmap . \
		    @[file join $tkWorld(image_dir) tkWorld.ic.xbm]
	}
    }
}
