/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "optionen.h"
#include "ConfigFile.H"
#include "wx/sizer.h"
#include "wx/config.h"
#include <wx/notebook.h>

enum {
  BTN_SAVE = 1,
  CHK_LANG,
  CHK_KEYB,
  CHK_DATA
};

BEGIN_EVENT_TABLE(ODialog, wxDialog)
  EVT_BUTTON(BTN_SAVE, ODialog::OnSave)
  EVT_CHECKBOX(wxID_ANY, ODialog::OnCheckBox)
END_EVENT_TABLE()

ODialog::ODialog(wxWindow* parent)
  : wxDialog(parent, -1, wxString(_("Settings"))),
    langSel(0),
    keybSel(0)
{
  wxNotebook* notebook = new wxNotebook(this,-1,wxDefaultPosition,
				       wxDefaultSize,wxNB_TOP);
  notebook->AddPage(getLocalizationPage(notebook),
			  _("Localization"), false);
  notebook->AddPage(getDataLocationPage(notebook),
			  _("Data location"), false);
  wxNotebookSizer* nbs = new wxNotebookSizer(notebook);

  /* now the buttons
   */
  wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
  buttonSizer->Add(new wxButton(this,BTN_SAVE, _("Save")),
		   10,wxALIGN_CENTER|wxRIGHT,10);
  buttonSizer->Add(new wxButton(this,wxID_CANCEL, _("Cancel")),
		   10,wxALIGN_CENTER);

  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(nbs,1,wxEXPAND);
  dialogSizer->Add(buttonSizer,0,wxALIGN_CENTER|wxALL,10);

  SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(this);
}

ODialog::~ODialog () {
}

#include <algorithm>
#ifndef __VISUALC__
  using std::max;
#endif

wxPanel* ODialog::getLocalizationPage (wxWindow* parent) {
  wxPanel* panel = new wxPanel(parent);

  int width = 0;
  wxStaticText* langText = new wxStaticText(panel,-1,_("Language:"));
  width = max(width,langText->GetSize().GetWidth());
  wxStaticText* keybText = new wxStaticText(panel,-1,_("Keyboard layout:"));
  width = max(width,keybText->GetSize().GetWidth());
  langText->SetSize(width,-1);
  keybText->SetSize(width,-1);

  /* These are the fields for the language settings
   */
  this->langOverride = new wxCheckBox(panel,CHK_LANG,
				      _("Override program language")
				      + wxString(_T(" ("))
				      + _("default: matches locale")
				      + wxString(_T(")")));
  this->langOverride->SetValue(TtConfigFile::getPtr()->issetLanguage());
  this->langOverride->SetToolTip(_("Activate this checkbox if you want to change the current language of the program"));
  wxFlexGridSizer* optionSizer1 = new wxFlexGridSizer(1,2,10,10);
  optionSizer1->Add(langText,0,wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
  optionSizer1->Add(getLangSelector(panel));
  this->langSel->Enable(this->langOverride->GetValue());

  /* These are the fields for the keyboard layout settings
   */
  this->keybOverride = new wxCheckBox(panel,CHK_KEYB,
				      _("Override keyboard layout")
				      + wxString(_T(" ("))
				      + _("default: matches locale")
				      + wxString(_T(")")));
  this->keybOverride->SetValue(TtConfigFile::getPtr()->issetKeyboardLayout());
  this->keybOverride->SetToolTip(_("Activate this checkbox if you want to use another keyboard layout"));
  wxFlexGridSizer* optionSizer2 = new wxFlexGridSizer(1,2,10,10);
  optionSizer2->Add(keybText,0,wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
  optionSizer2->Add(getKeyboardSelector(panel));
  this->keybSel->Enable(this->keybOverride->GetValue());


  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(this->langOverride,0,
		   wxEXPAND|wxALIGN_CENTER|wxTOP|wxLEFT|wxRIGHT,10);
  dialogSizer->Add(optionSizer1,0,wxEXPAND|wxALIGN_CENTER|wxALL,10);
  dialogSizer->Add(this->keybOverride,0,wxEXPAND|wxALIGN_CENTER|wxALL,10);
  dialogSizer->Add(optionSizer2,0,
		   wxEXPAND|wxALIGN_CENTER|wxBOTTOM|wxLEFT|wxRIGHT,10);

  panel->SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(panel);
  return panel;
}

wxComboBox* ODialog::getLangSelector (wxWindow* parent) {
  if (this->langSel == 0) {
    this->langSel = new wxComboBox(parent, -1, _T(""), wxDefaultPosition,
				   wxDefaultSize, 0, NULL, wxCB_READONLY);
    int i = 0;
    wxString l = TtConfigFile::getPtr()->getLanguage();
    while (supported_langs[i].name != _T("")) {
      this->langSel->Append(supported_langs[i].name);
      if (l == supported_langs[i].name) {
	this->langSel->SetSelection(i);
      }
      ++i;
    }
    if (l == _T("")) {
      this->langSel->SetSelection(current_lang);
    }
  }
  return this->langSel;
}

wxComboBox* ODialog::getKeyboardSelector (wxWindow* parent) {
  if (this->keybSel == 0) {
    wxString maps[] = {
      _("English"),
      _("German")
    };
    this->keybSel =  new wxComboBox(parent, -1, _T(""), wxDefaultPosition,
			     wxDefaultSize, 2, maps, wxCB_READONLY);
    wxString l = TtConfigFile::getPtr()->getKeyboardLayout();
    if (l == _T("german")) {
      this->keybSel->SetSelection(1);
    } else {
      this->keybSel->SetSelection(0);
    }
  }
  return this->keybSel;
}

wxPanel* ODialog::getDataLocationPage (wxWindow* parent) {
  wxPanel* panel = new wxPanel(parent);

  this->dataOverride = new wxCheckBox(panel,CHK_DATA,
				      _("Override data location")
				      + wxString(_T(" ("))
				      + _("default: ")
				      + _(LECTDIR)
				      + wxString(_T(")")));
  this->dataOverride->SetToolTip(_("Activate this checkbox if you want to change the default data folder where lessions, images and language files are stored"));

  wxBoxSizer* dialogSizer = new wxBoxSizer(wxVERTICAL);
  dialogSizer->Add(this->dataOverride,0,
		   wxEXPAND|wxALIGN_CENTER|wxTOP|wxLEFT|wxRIGHT,10);
  dialogSizer->Add(getSourceSizer(panel),1,wxEXPAND|wxALL,10);

  this->dataOverride->SetValue(TtConfigFile::getPtr()->issetDataBaseUrl());
  this->url->Enable(this->dataOverride->GetValue());

  panel->SetSizer(dialogSizer);
  dialogSizer->SetSizeHints(panel);
  return panel;
}

wxSizer* ODialog::getSourceSizer (wxWindow* parent) {
  wxStaticBox* sb = new wxStaticBox(parent, -1, _("Data location URL"));
  wxStaticBoxSizer* sbSizer = new wxStaticBoxSizer(sb, wxVERTICAL);
  if (TtConfigFile::getPtr()->issetDataBaseUrl()) {
    UrlFile u(TtConfigFile::getPtr()->getDataBaseUrl());
    this->url = new DirUrlSelectPanel(parent,-1,u);
  } else {
    this->url = new DirUrlSelectPanel(parent,-1);
  }
  sbSizer->Add(this->url,1,wxEXPAND);
  return sbSizer;
}

void ODialog::OnSave (wxCommandEvent& WXUNUSED(event)) {
  if (this->dataOverride->GetValue()) {
    if (!this->url->allFieldsValid()) {
      wxMessageBox(_("You specified an invalid configuration for the data location."),
		   _("Important!"), wxOK|wxICON_INFORMATION|wxCENTRE, this);
      return;
    } else {
      //data location setting
      TtConfigFile::getPtr()->setDataBaseUrl(this->url->getURLstr());
    }
  } else {
    TtConfigFile::getPtr()->setDataBaseUrl(_T(""));
  }

  wxString l[] = {
    _T("english"),
    _T("german")
  };

  // Language setting
  wxString oldSel1 = TtConfigFile::getPtr()->getLanguage();
  if (this->langOverride->GetValue()) {
    TtConfigFile::getPtr()->setLanguage(supported_langs[this->langSel->GetSelection()].name);
  } else {
    TtConfigFile::getPtr()->setLanguage(_T(""));    
  }
  wxString newSel1 = TtConfigFile::getPtr()->getLanguage();

  //Keyboard setting
  wxString oldSel2 = TtConfigFile::getPtr()->getKeyboardLayout();
  if (this->keybOverride->GetValue()) {
    TtConfigFile::getPtr()->setKeyboardLayout(l[this->keybSel->GetSelection()]);
  } else {
    TtConfigFile::getPtr()->setKeyboardLayout(_T(""));
  }
  wxString newSel2 = TtConfigFile::getPtr()->getKeyboardLayout();

  if (oldSel1 != newSel1 || oldSel2 != newSel2) {
    //note that this always refers to the comparison of
    //saved state against new saved state, NOT current application's state
    wxMessageBox(_("You may need to restart the program\nto let new language setting take effect."),
		 _("Important!"), wxOK|wxICON_INFORMATION|wxCENTRE, this);
  }

  EndModal(wxID_OK);
}


void ODialog::OnCheckBox (wxCommandEvent& event) {
  switch(event.GetId()) {
  case CHK_LANG:
    this->langSel->Enable(this->langOverride->GetValue());
    break;
  case CHK_KEYB:
    this->keybSel->Enable(this->keybOverride->GetValue());
    break;
  case CHK_DATA:
    this->url->Enable(this->dataOverride->GetValue());
    break;
  }
}
