/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "ConfigFile.H"
#include "lektionsanweisung.h"
#include "commonElements.H"
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/image.h>
#include <wx/ffile.h>
#include <wx/config.h>

LessonStartDlg::LessonStartDlg(wxWindow* parent, int Lektion, wxString k,
			       wxWindowID id , const wxString& title, const wxPoint& pos, 
			       const wxSize& size , long style, const wxString& name)
  : wxDialog(parent, id, title, pos, size, style, name),
    lektion(Lektion)
{
  //read the picture path and add the picture
  LessonPath f;
  f.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  wxString s(_T("lektion"));
  s << Lektion;
  f.setFileName(s);
  f.setFileExt(_T("png"));

  wxBitmap* bmp = common::getBitmap(f);

  f.setFileName(_T("lektion"));
  s.Empty();
  s << _T("a") << Lektion;
  f.setFileExt(s);

  wxURL* u = f.getURL();
  wxInputStream* stream = common::getInputStream(*u);
  wxString text;
  if (stream == 0) {
    ::wxLogError(_("Cannot load file %s"), f.getFullFileName().c_str());    
  } else {
    //load and insert the text
    text = common::readTextAll(*stream);
  }
  delete stream;
  delete u;

  if (k != _T("")) {
    text << _T("\n") << k;
  }

  //arrange the elements
  wxBoxSizer *dialogSizer = new wxBoxSizer(wxVERTICAL);
  if (bmp != 0) {
    dialogSizer->Add(new wxStaticBitmap(this, -1, *bmp), 
		     0, wxLEFT|wxRIGHT|wxTOP|wxALIGN_CENTRE,10);
  }
  dialogSizer->Add(CreateTextSizer(text),0,
		   wxEXPAND|wxLEFT|wxRIGHT|wxTOP,10);
  dialogSizer->Add(new wxStaticLine(this,-1),0,
		   wxEXPAND|wxLEFT|wxRIGHT|wxTOP,10);
  dialogSizer->Add(CreateButtonSizer(wxOK),0,
		   wxCENTRE|wxALL,10);
  dialogSizer->SetSizeHints(this);
  SetSizer(dialogSizer);
  Center();
}

LessonStartDlg::~LessonStartDlg () {
}
