# Override libdir for plugin install
%define _libdir /usr/lib/kino-gtk2

Summary: Kino plugins for image transformation and filtering
Name: timfx
Version: 0.2.2
Release: 1
Group: Applications/Multimedia
Source0: %{name}-%{version}.tar.gz
Source1: kino-timfx-lumas.tar.gz
URL: http://kino.schirmacher.de/
License: GPL
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: kino-devel >= 0.7.0, gtkmm2-devel
Requires: kino >= 0.7.0, gtkmm2

%description
The modest little collection of Kino plugins with the immodest name.
Currently, timfx features the Image Luma transition, which creates a
limitless variety of high quality (interlaced) soft wipes based on the
luma in images you supply, while the Color Hold filter removes all chroma
from images exept for a single color that you designate (you may recall
the little girl in red from the otherwise black-and-white film
Schindler's List). The Blur filter efficiently blurs your video with
control over the blur radius, while the Soft Focus filter can make your
source footage dreamlike / romantic - you can put away those pantyhose!
The Corner Out plugin is an experimental DVE transition implemented in
OpenGL - over time, I hope to develop experience working with OpenGL
for creating more complex DVE effects for the next-generation Kino
plugin API. 

%prep
%setup -q

%build
%configure
make %{_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall

# Extract sample luma maps
mkdir -p %{buildroot}/%{_datadir}/kino/effects
tar -xz -C %{buildroot}/%{_datadir}/kino/effects -f %{SOURCE1}

%clean
rm -rf %{buildroot}

%files 
%defattr(-, root, root)
%doc AUTHORS ChangeLog COPYING NEWS README
%{_libdir}/libtimfx.la
%{_libdir}/libtimfx.so.0.0.0
%{_datadir}/kino/effects/*

%changelog
* Mon Jan 19 2004 David Hollis <dhollis@davehollis.com>	0.2.0-1
- Package created
