/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#include <cstdio>
#include <cstdlib>
#include <iostream>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "thoughttracker.h"
#include "util.h"

//.............................................................................
void*
smalloc(long amount)
{
  void *p = 0;

  p = malloc(amount);
  if (!p) {
    cerr << _("Out of memory in smalloc()!") << endl;
    exit(EXIT_FAILURE);
  }
  return p;
}

//.............................................................................
void
sfree(void *ptr)
{
  if (ptr) {
    free(ptr);
    ptr = 0;
  }
}

//.............................................................................
void
cfg_quote(string &s, bool strict)
{
  // only quote if necessary or explicitly requested
  if (strict || s.find(" ", 0) < s.length() || s.find("\"", 0) < s.length()) {
    // escape backslashes
    for (int i = 0; (i = s.find("\\", i)) >= 0; ) {
      s.replace(i, 1, "\\\\");
      i += 2;
    }
    // escape quotes
    for (int i = 0; (i = s.find("\"", i)) >= 0; ) {
      s.replace(i, 1, "\\\"");
      i += 2;
    }
    // add surrounding quotes
    s = "\"" + s + '"';  // add surrounding quotes
  }
}

//.............................................................................
void
cfg_unquote(string &s)
{
  // only unquote of actually quoted
  if (s.length() && s[0] == '"' && s[s.length()-1] == '"') {
    // remove surrounding quotes
    s.erase(s.length()-1, 1).erase(0, 1);
    // unescape backslashes
    for (int i = 0; (i = s.find("\\", i)) >= 0; ) {
      if ((unsigned int) i < s.length()-1 && s[i+1]) s.erase(i, 1);
      i++;
    }
  }
}

