/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DialogMessageArea {
    private Text messageText;
    private Label messageImageLabel;
    private Composite messageComposite;
    private String lastMessageText;
    private int lastMessageType;
    private CLabel titleLabel;

    public void createContents(Composite parent) {
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground(display);
        Color foreground = JFaceColors.getBannerForeground(display);
        this.titleLabel = new CLabel(parent, 0);
        JFaceColors.setColors((Control)this.titleLabel, foreground, background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.messageComposite = new Composite(parent, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageLayout.makeColumnsEqualWidth = false;
        this.messageComposite.setLayout((Layout)messageLayout);
        this.messageImageLabel = new Label(this.messageComposite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage("dialog_messasge_info_image"));
        this.messageImageLabel.setLayoutData((Object)new GridData(4));
        this.messageImageLabel.setBackground(parent.getDisplay().getSystemColor(7));
        this.messageText = new Text(this.messageComposite, 0);
        this.messageText.setEditable(false);
        this.messageText.setBackground(parent.getDisplay().getSystemColor(3));
        GridData textData = new GridData(772);
        this.messageText.setLayoutData((Object)textData);
        this.setMessageColors(JFaceColors.getBannerBackground(this.messageComposite.getDisplay()));
    }

    public void setTitleLayoutData(Object layoutData) {
        this.titleLabel.setLayoutData(layoutData);
    }

    public void setMessageLayoutData(Object layoutData) {
        this.messageComposite.setLayoutData(layoutData);
    }

    public void showTitle(String titleMessage, Image titleImage) {
        this.titleLabel.setImage(titleImage);
        this.titleLabel.setText(titleMessage);
        this.restoreTitle();
    }

    public void restoreTitle() {
        this.titleLabel.setVisible(true);
        this.messageComposite.setVisible(false);
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    public void updateText(String newMessage, int newType) {
        Image newImage = null;
        boolean showingError = false;
        switch (newType) {
            case 0: {
                if (newMessage == null) {
                    this.restoreTitle();
                } else {
                    this.showTitle(newMessage, null);
                }
                return;
            }
            case 1: {
                newImage = JFaceResources.getImage("dialog_messasge_info_image");
                break;
            }
            case 2: {
                newImage = JFaceResources.getImage("dialog_messasge_warning_image");
                break;
            }
            case 3: {
                newImage = JFaceResources.getImage("dialog_message_error_image");
                showingError = true;
            }
        }
        this.messageComposite.setVisible(true);
        this.titleLabel.setVisible(false);
        if (newMessage.equals(this.messageText.getText()) && newImage == this.messageImageLabel.getImage()) {
            return;
        }
        this.messageImageLabel.setImage(newImage);
        this.messageText.setText(newMessage);
        if (showingError) {
            this.setMessageColors(JFaceColors.getErrorBackground(this.messageComposite.getDisplay()));
        } else {
            this.lastMessageText = newMessage;
            this.setMessageColors(JFaceColors.getBannerBackground(this.messageComposite.getDisplay()));
        }
    }

    private void setMessageColors(Color color) {
        this.messageText.setBackground(color);
        this.messageComposite.setBackground(color);
        this.messageImageLabel.setBackground(color);
    }

    public void clearErrorMessage() {
        if (this.lastMessageText == null) {
            this.restoreTitle();
        } else {
            this.updateText(this.lastMessageText, this.lastMessageType);
        }
    }
}

