/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.internal.graph.GraphVisitor;

public class VerticalPlacement
extends GraphVisitor {
    public void visit(DirectedGraph g) {
        int currentY = 0;
        int row = 0;
        while (row < g.ranks.size()) {
            Node node;
            int rowHeight = 0;
            int rowAscent = 0;
            int rowDescent = 0;
            Rank rank = g.ranks.getRank(row);
            int n = 0;
            while (n < rank.size()) {
                node = rank.getNode(n);
                Insets pad = g.getPadding(node);
                rowHeight = Math.max(node.height, rowHeight);
                rowAscent = Math.max(pad.top, rowAscent);
                rowDescent = Math.max(pad.bottom, rowDescent);
                ++n;
            }
            currentY += rowAscent;
            n = 0;
            while (n < rank.size()) {
                node = rank.getNode(n);
                node.y = currentY;
                node.height = rowHeight;
                ++n;
            }
            currentY += rowHeight + rowDescent;
            ++row;
        }
    }
}

