/*
 *  $Id: uimcontainer.c 9 2004-02-06 06:24:52Z omote $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "uimcontainer.h"
#include "uimconfig.h"
#include "intl.h"

static UimConfigPaneGlobal *uim_config_pane_global_new (struct _uim_config_global *);
static UimConfigPaneAnthy *uim_config_pane_anthy_new   (struct _uim_config_anthy  *);
static UimConfigPaneCanna *uim_config_pane_canna_new   (struct _uim_config_canna  *);
static UimConfigPanePrime *uim_config_pane_prime_new   (struct _uim_config_prime  *);
static UimConfigPaneSkk	  *uim_config_pane_skk_new     (struct _uim_config_skk    *);

static struct _uim_config uim_config;

static char *inputmethod[] = {
    "Anthy",
    "Canna",
    "PRIME",
    "T-Code",
    "TUT-Code",
};

static char *cand_win_pos[] = {
    "left",
    "right",
};

static char *skk_style[] = {
    "uim",
    "ddskk",
};

/* callbacks */
static void cb_uim_specify_check_button_clicked	   (GtkWidget *, gpointer);
static void cb_uim_config_pane_save_button_clicked (GtkButton *, UimConfigContainer *);

UimConfigContainer *uim_config_container_new(void){
    UimConfigContainer	*container;
    UimConfigPaneGlobal *config_pane_global;
    UimConfigPaneAnthy	*config_pane_anthy;
    UimConfigPaneCanna	*config_pane_canna;
    UimConfigPanePrime	*config_pane_prime;
    UimConfigPaneSkk	*config_pane_skk;

    GtkWidget *notebook, *vbox1, *hbuttonbox;
    GtkWidget *label_global, *label_skk;
    GtkWidget *label_prime,  *label_anthy, *label_canna;
    GtkWidget *button_save, *separator;
    gint i = 0;
    gint ret;

    ret = init_uim_config(&uim_config);
    /* I changed coding style a little. */
    container = g_malloc0(sizeof(UimConfigContainer));

    vbox1 = gtk_vbox_new(FALSE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 10);

    notebook = gtk_notebook_new();
    gtk_widget_show(notebook);
    gtk_box_pack_start(GTK_BOX(vbox1), notebook, TRUE, TRUE, 0);

    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
    gtk_container_set_border_width(GTK_CONTAINER(notebook), 0);

    config_pane_global = uim_config_pane_global_new(&(uim_config.global));
    gtk_container_add(GTK_CONTAINER(notebook), config_pane_global->pane);
    gtk_widget_show(config_pane_global->pane);
    label_global = gtk_label_new("Global");
    gtk_widget_show(label_global);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i),
			       label_global);
    i++;
/*
    config_pane_anthy  = uim_config_pane_anthy_new(&(uim_config.anthy));
    gtk_container_add(GTK_CONTAINER(notebook), config_pane_anthy->pane);
    gtk_widget_show(config_pane_anthy->pane);
    label_anthy = gtk_label_new("Anthy");
    gtk_widget_show(label_anthy);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i),
			       label_anthy);
    i++;
*/
    config_pane_canna  = uim_config_pane_canna_new(&(uim_config.canna));
    gtk_container_add(GTK_CONTAINER(notebook), config_pane_canna->pane);
    gtk_widget_show(config_pane_canna->pane);
    label_canna = gtk_label_new("Canna");
    gtk_widget_show(label_canna);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i),
			       label_canna);
    i++;
/*
    config_pane_prime  = uim_config_pane_prime_new(&(uim_config.prime));
    gtk_container_add(GTK_CONTAINER(notebook), config_pane_prime->pane);
    gtk_widget_show(config_pane_prime->pane);
    label_prime = gtk_label_new("PRIME");
    gtk_widget_show(label_prime);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i),
			       label_prime);
    i++;
*/
    config_pane_skk    = uim_config_pane_skk_new(&(uim_config.skk));
    gtk_container_add(GTK_CONTAINER(notebook), config_pane_skk->pane);
    gtk_widget_show(config_pane_skk->pane);
    label_skk = gtk_label_new("SKK");
    gtk_widget_show(label_skk);
    gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
			       gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), i),
			       label_skk);
    i++;

    separator = gtk_hseparator_new();
    gtk_widget_show(separator);
    gtk_box_pack_start(GTK_BOX(vbox1), separator, FALSE, FALSE, 0);

    hbuttonbox = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
    gtk_box_set_spacing(GTK_BOX(hbuttonbox), 10);
    gtk_widget_show(hbuttonbox);
    gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox, FALSE, FALSE, 10);

    button_save = gtk_button_new_with_label(_("Apply"));
    gtk_widget_show(button_save);
    gtk_box_pack_start(GTK_BOX(hbuttonbox), button_save, FALSE, FALSE, 10);

    g_signal_connect(G_OBJECT(button_save), "clicked",
		     G_CALLBACK(cb_uim_config_pane_save_button_clicked),
		     container);

    container->container = vbox1;
    container->button_save = button_save;

    container->uim_config_pane_global = config_pane_global;
    container->uim_config_pane_anthy  = config_pane_anthy;
    container->uim_config_pane_canna  = config_pane_canna;
    container->uim_config_pane_prime  = config_pane_prime;
    container->uim_config_pane_skk    = config_pane_skk;

    return container;
}

static UimConfigPaneGlobal *uim_config_pane_global_new(struct _uim_config_global *config)
{
    UimConfigPaneGlobal *pane;
    GtkWidget *optmenu_default_im;
    GtkWidget *chk_enable_im_switch;
    GtkWidget *optmenu_cand_win_pos;

    GtkWidget *label1, *label2, *label3;
    GtkWidget *menu_im, *menuitem_im;
    GtkWidget *alignment_default_im;
    GtkWidget *menu_pos, *menuitem_pos;
    GtkWidget *alignment_pos;
    GtkWidget *table;
    gint i, size, num;

    pane = g_malloc0(sizeof(UimConfigPaneGlobal));

    table = gtk_table_new(4, 3, FALSE);

    label1 = gtk_label_new(_("Default InputMethod:"));
    gtk_misc_set_alignment(GTK_MISC(label1), 1.0, 0.5);
    gtk_widget_show(label1);
    gtk_table_attach(GTK_TABLE(table), label1,
		     0, 1, 0, 1, GTK_FILL, 0, 5, 5);

    label2 = gtk_label_new(_("Candidate window position:"));
    gtk_misc_set_alignment(GTK_MISC(label2), 1.0, 0.5);
    gtk_widget_show(label2);
    gtk_table_attach(GTK_TABLE(table), label2,
		     0, 1, 1, 2, GTK_FILL, 0, 5, 5);

    chk_enable_im_switch = gtk_check_button_new_with_label(_("Enable IM switching"));
    gtk_widget_show(chk_enable_im_switch);
    gtk_table_attach(GTK_TABLE(table), chk_enable_im_switch,
		     0, 1, 3, 4, GTK_FILL, 0, 5, 5);
    if(config->enable_im_switch == 1)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_enable_im_switch), TRUE);

    optmenu_default_im = gtk_option_menu_new();
    menu_im = gtk_menu_new();

    size = sizeof(inputmethod) / sizeof(inputmethod[0]);
    num = 0;
    for(i = 0; i < size; i++) {
	menuitem_im = gtk_menu_item_new_with_label(inputmethod[i]);	   
	gtk_menu_shell_append(GTK_MENU_SHELL(menu_im), menuitem_im);
	gtk_widget_show(menuitem_im);
	if(config->default_im != NULL &&
	   strcasecmp(config->default_im, inputmethod[i]) == 0)
	    num = i;
    }
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu_default_im), menu_im);
    gtk_widget_show(optmenu_default_im);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu_default_im), num);

    alignment_default_im = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(alignment_default_im), optmenu_default_im);
    gtk_widget_show(alignment_default_im);
    gtk_table_attach(GTK_TABLE(table), alignment_default_im,
		     1, 2, 0, 1, GTK_FILL, 0, 5, 5);

    optmenu_cand_win_pos = gtk_option_menu_new();
    menu_pos = gtk_menu_new();

    size = sizeof(cand_win_pos) / sizeof(cand_win_pos[0]);
    num = 0;
    for(i = 0; i < size; i++) {
	menuitem_pos = gtk_menu_item_new_with_label(cand_win_pos[i]);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu_pos), menuitem_pos);
	gtk_widget_show(menuitem_pos);
	if(config->cand_win_pos != NULL &&
	   strcasecmp(config->cand_win_pos, cand_win_pos[i]) == 0)
	    num = i;
    }

    gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu_cand_win_pos), menu_pos);
    gtk_widget_show(optmenu_cand_win_pos);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu_cand_win_pos), num);

    alignment_pos = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(alignment_pos), optmenu_cand_win_pos);
    gtk_widget_show(alignment_pos);
    gtk_table_attach(GTK_TABLE(table), alignment_pos,
		     1, 2, 1, 2, GTK_FILL, 0, 5, 5);

    pane->pane = table;
    pane->chk_enable_im_switch = chk_enable_im_switch;
    pane->optmenu_default_im = optmenu_default_im;
    pane->optmenu_cand_win_pos = optmenu_cand_win_pos;
    return pane;
};

/*
static UimConfigPaneAnthy *uim_config_pane_anthy_new(UimConfigAnthy *config)
{
    UimConfigPaneAnthy *pane;
    GtkWidget *label1;
    pane = g_malloc0(sizeof(UimConfigPaneAnthy));

    pane->pane = gtk_table_new(4, 2, FALSE);

    return pane;
};
*/

static UimConfigPaneCanna *uim_config_pane_canna_new(struct _uim_config_canna *config)
{
    UimConfigPaneCanna *pane;
    GtkWidget *table;
    GtkWidget *chk_specify_cannaserver;
    GtkWidget *entry_cannaserver;

    pane = g_malloc0(sizeof(UimConfigPaneCanna));

    table = gtk_table_new(4, 2, FALSE);

    chk_specify_cannaserver = gtk_check_button_new_with_label(_("Use remote cannaserver"));
    gtk_widget_show(chk_specify_cannaserver);
    gtk_table_attach(GTK_TABLE(table), chk_specify_cannaserver,
		     0, 1, 0, 1, GTK_FILL, 0, 5, 5);
    g_signal_connect(G_OBJECT(chk_specify_cannaserver), "clicked",
		     G_CALLBACK(cb_uim_specify_check_button_clicked),
		     pane);

    entry_cannaserver = gtk_entry_new();
    gtk_widget_show(entry_cannaserver);
    gtk_table_attach(GTK_TABLE(table), entry_cannaserver,
		     1, 2, 0, 1, GTK_FILL, 0, 5, 5);

    if(config->cannaserver != NULL) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_specify_cannaserver), TRUE);
	gtk_widget_set_sensitive(entry_cannaserver, TRUE);
	gtk_entry_set_text(GTK_ENTRY(entry_cannaserver), config->cannaserver);
    } else {
	gtk_widget_set_sensitive(entry_cannaserver, FALSE);
    }

    pane->pane = table;
    pane->chk_specify_cannaserver = chk_specify_cannaserver;
    pane->entry_cannaserver = entry_cannaserver;
    return pane;
};

/*
static UimConfigPanePrime *uim_config_pane_prime_new(UimConfigPrime *config)
{
    UimConfigPanePrime *pane;
    GtkWidget *label1;
    pane = g_malloc0(sizeof(UimConfigPanePrime));

    pane->pane = gtk_table_new(4, 2, FALSE);

    return pane;
};
*/

static UimConfigPaneSkk *uim_config_pane_skk_new(struct _uim_config_skk *config)
{
    UimConfigPaneSkk *pane;
    GtkWidget *table;
    GtkWidget *label1;
    GtkWidget *chk_specify_skk_dic_filename;
    GtkWidget *entry_skk_dic_filename;
    GtkWidget *chk_specify_skk_userdic_filename;
    GtkWidget *entry_skk_userdic_filename;
    GtkWidget *chk_specify_skk_uim_userdic_filename;
    GtkWidget *entry_skk_uim_userdic_filename;
    GtkWidget *chk_recursive_learning;
    GtkWidget *optmenu_skk_style;
    GtkWidget *menu_style, *menuitem_style;
    GtkWidget *alignment_style;
    gint i, size, num;

    pane = g_malloc0(sizeof(UimConfigPaneSkk));

    table = gtk_table_new(6, 2, FALSE);

    chk_specify_skk_dic_filename = gtk_check_button_new_with_label
	(_("Specify SKK dic filename"));
    gtk_widget_show(chk_specify_skk_dic_filename);
    g_signal_connect(G_OBJECT(chk_specify_skk_dic_filename), "clicked",
		     G_CALLBACK(cb_uim_specify_check_button_clicked),
		     pane);
    gtk_table_attach(GTK_TABLE(table), chk_specify_skk_dic_filename,
		     0, 1, 0, 1, GTK_FILL, 0, 5, 5);

    entry_skk_dic_filename = gtk_entry_new();
    gtk_widget_show(entry_skk_dic_filename);
    gtk_table_attach(GTK_TABLE(table), entry_skk_dic_filename,
		     1, 2, 0, 1, GTK_FILL, 0, 5, 5);

    if(config->skk_dic_filename != NULL) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_specify_skk_dic_filename),
				     TRUE);
	gtk_widget_set_sensitive(entry_skk_dic_filename, TRUE);
	gtk_entry_set_text(GTK_ENTRY(entry_skk_dic_filename), config->skk_dic_filename);
    } else {
	gtk_widget_set_sensitive(entry_skk_dic_filename, FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry_skk_dic_filename), "/usr/share/skk/SKK-JISYO.L");
    }

    chk_specify_skk_userdic_filename = gtk_check_button_new_with_label
	(_("Specify SKK userdic filename"));
    gtk_widget_show(chk_specify_skk_userdic_filename);
    g_signal_connect(G_OBJECT(chk_specify_skk_userdic_filename), "clicked",
		     G_CALLBACK(cb_uim_specify_check_button_clicked),
		     pane);
    gtk_table_attach(GTK_TABLE(table), chk_specify_skk_userdic_filename,
		     0, 1, 1, 2, GTK_FILL, 0, 5, 5);

    entry_skk_userdic_filename = gtk_entry_new();
    gtk_widget_show(entry_skk_userdic_filename);
    gtk_table_attach(GTK_TABLE(table), entry_skk_userdic_filename,
		     1, 2, 1, 2, GTK_FILL, 0, 5, 5);

    if(config->skk_userdic_filename != NULL) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_specify_skk_userdic_filename),
				     TRUE);
	gtk_widget_set_sensitive(entry_skk_userdic_filename, TRUE);
	gtk_entry_set_text(GTK_ENTRY(entry_skk_userdic_filename),
			   config->skk_userdic_filename);
    } else {
	gtk_entry_set_text(GTK_ENTRY(entry_skk_userdic_filename), "~/.skk-jisyo");
	gtk_widget_set_sensitive(entry_skk_userdic_filename, FALSE);
    }

    chk_specify_skk_uim_userdic_filename = gtk_check_button_new_with_label
	(_("Specify SKK userdic on uim filename"));
    gtk_widget_show(chk_specify_skk_uim_userdic_filename);
    g_signal_connect(G_OBJECT(chk_specify_skk_uim_userdic_filename), "clicked",
		     G_CALLBACK(cb_uim_specify_check_button_clicked),
		     pane);
    gtk_table_attach(GTK_TABLE(table), chk_specify_skk_uim_userdic_filename,
		     0, 1, 2, 3, GTK_FILL, 0, 5, 5);

    entry_skk_uim_userdic_filename = gtk_entry_new();
    gtk_widget_show(entry_skk_uim_userdic_filename);
    gtk_table_attach(GTK_TABLE(table), entry_skk_uim_userdic_filename,
		     1, 2, 2, 3, GTK_FILL, 0, 5, 5);

    if(config->skk_uim_userdic_filename != NULL) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_specify_skk_uim_userdic_filename),
				     TRUE);
	gtk_widget_set_sensitive(entry_skk_uim_userdic_filename, TRUE);
	gtk_entry_set_text(GTK_ENTRY(entry_skk_uim_userdic_filename),
			   config->skk_uim_userdic_filename);
    } else {
	gtk_widget_set_sensitive(entry_skk_uim_userdic_filename, FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry_skk_uim_userdic_filename), "~/.skk-uim-jisyo");
    }

    chk_recursive_learning = gtk_check_button_new_with_label(_("Enable recursive learning"));
    gtk_widget_show(chk_recursive_learning);
    gtk_table_attach(GTK_TABLE(table), chk_recursive_learning,
		     0, 1, 3, 4, GTK_FILL, 0, 5, 5);
    if(config->recursive_learning == 1)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_recursive_learning), TRUE);

    label1 = gtk_label_new(_("SKK Input Style:"));
    gtk_misc_set_alignment(GTK_MISC(label1), 1.0, 0.5);
    gtk_widget_show(label1);
    gtk_table_attach(GTK_TABLE(table), label1,
		     0, 1, 4, 5, GTK_FILL, 0, 5, 5);

    optmenu_skk_style = gtk_option_menu_new();
    menu_style = gtk_menu_new();

    size = sizeof(skk_style) / sizeof(skk_style[0]);
    num = 0;
    for(i = 0; i < size; i++) {
	menuitem_style = gtk_menu_item_new_with_label(skk_style[i]);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu_style), menuitem_style);
	gtk_widget_show(menuitem_style);
	if(config->skk_style != NULL && strcasecmp(config->skk_style, skk_style[i]) == 0)
	    num = i;
    }

    gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu_skk_style), menu_style);
    gtk_widget_show(optmenu_skk_style);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu_skk_style), num);

    alignment_style = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(alignment_style), optmenu_skk_style);
    gtk_widget_show(alignment_style);
    gtk_table_attach(GTK_TABLE(table), alignment_style,
		     1, 2, 4, 5, GTK_FILL, 0, 5, 5);

    pane->pane = table;
    pane->chk_specify_skk_dic_filename = chk_specify_skk_dic_filename;
    pane->entry_skk_dic_filename = entry_skk_dic_filename;
    pane->chk_specify_skk_userdic_filename = chk_specify_skk_userdic_filename;
    pane->entry_skk_userdic_filename = entry_skk_userdic_filename;
    pane->chk_specify_skk_uim_userdic_filename = chk_specify_skk_uim_userdic_filename;
    pane->entry_skk_uim_userdic_filename = entry_skk_uim_userdic_filename;
    pane->chk_recursive_leaning = chk_recursive_learning;
    pane->optmenu_skk_style = optmenu_skk_style;

    return pane;
};

static void
cb_uim_specify_check_button_clicked(GtkWidget *button, gpointer data)
{
    gboolean sensitive;

    if (button == ((UimConfigPaneSkk*)(data))->chk_specify_skk_dic_filename)
    {
	UimConfigPaneSkk *pane = (UimConfigPaneSkk*)data;
	sensitive = GTK_WIDGET_IS_SENSITIVE(pane->entry_skk_dic_filename);
	gtk_widget_set_sensitive(pane->entry_skk_dic_filename, !sensitive);
    }
    else if (button == ((UimConfigPaneSkk*)(data))->chk_specify_skk_userdic_filename)
    {
	UimConfigPaneSkk *pane = (UimConfigPaneSkk*)data;
	sensitive = GTK_WIDGET_IS_SENSITIVE(pane->entry_skk_userdic_filename);
	gtk_widget_set_sensitive(pane->entry_skk_userdic_filename, !sensitive);
    }
    else if (button == ((UimConfigPaneSkk*)(data))->chk_specify_skk_uim_userdic_filename)
    {
	UimConfigPaneSkk *pane = (UimConfigPaneSkk*)data;
	sensitive = GTK_WIDGET_IS_SENSITIVE(pane->entry_skk_uim_userdic_filename);
	gtk_widget_set_sensitive(pane->entry_skk_uim_userdic_filename, !sensitive);
    }
    else if (button == ((UimConfigPaneCanna*)(data))->chk_specify_cannaserver)
    {
	UimConfigPaneCanna *pane = (UimConfigPaneCanna*)data;
	sensitive = GTK_WIDGET_IS_SENSITIVE(pane->entry_cannaserver);
	gtk_widget_set_sensitive(pane->entry_cannaserver, !sensitive);
    }
}

static
void cb_uim_config_pane_save_button_clicked(GtkButton *button,
					    UimConfigContainer *container)
{
    struct _uim_config config;
    UimConfigPaneGlobal *global = container->uim_config_pane_global;
    UimConfigPaneAnthy *anthy	= container->uim_config_pane_anthy;
    UimConfigPaneCanna *canna	= container->uim_config_pane_canna;
    UimConfigPanePrime *prime	= container->uim_config_pane_prime;
    UimConfigPaneSkk   *skk	= container->uim_config_pane_skk;
    int i;

    /* global */
    i = gtk_option_menu_get_history(GTK_OPTION_MENU(global->optmenu_default_im));
    (config.global).default_im = g_strdup(inputmethod[i]);
    i = gtk_option_menu_get_history(GTK_OPTION_MENU(global->optmenu_cand_win_pos));
    (config.global).cand_win_pos = g_strdup(cand_win_pos[i]);
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(global->chk_enable_im_switch)))
	config.global.enable_im_switch = 1;
    else
	config.global.enable_im_switch = 0;

    /* canna */
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(canna->chk_specify_cannaserver)))
	config.canna.cannaserver =
	    g_strdup(gtk_entry_get_text(GTK_ENTRY(canna->entry_cannaserver)));
    else
	config.canna.cannaserver = NULL;

    /* skk */
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(skk->chk_specify_skk_dic_filename)))
	config.skk.skk_dic_filename
	    = g_strdup(gtk_entry_get_text(GTK_ENTRY(skk->entry_skk_dic_filename)));
    else
	config.skk.skk_dic_filename = NULL;

    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(skk->chk_specify_skk_userdic_filename)))
	config.skk.skk_userdic_filename
	    = g_strdup(gtk_entry_get_text(GTK_ENTRY(skk->entry_skk_userdic_filename)));
    else
	config.skk.skk_userdic_filename = NULL;

    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(skk->chk_specify_skk_uim_userdic_filename)))
	config.skk.skk_userdic_filename
	    = g_strdup(gtk_entry_get_text(GTK_ENTRY(skk->entry_skk_uim_userdic_filename)));
    else
	config.skk.skk_uim_userdic_filename = NULL;

    config.skk.recursive_learning =
	gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(skk->chk_recursive_leaning));

    i = gtk_option_menu_get_history(GTK_OPTION_MENU(skk->optmenu_skk_style));
    config.skk.skk_style = g_strdup(skk_style[i]);

    write_uim_config(&config);
}
