/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: ContainerFactory.pike,v 1.1.1.1 2005/02/23 14:47:21 cvs Exp $
 */

constant cvs_version="$Id: ContainerFactory.pike,v 1.1.1.1 2005/02/23 14:47:21 cvs Exp $";

inherit "/factories/ObjectFactory";

//! This factory creates intances of the class Container.

import Attributes;

#include <macros.h>
#include <classes.h>
#include <access.h>
#include <database.h>
#include <events.h>
#include <attributes.h>
#include <types.h>

static void
create_object()
{
    ::create_object();
    register_attribute(Attribute(CONT_SIZE_X, "x-size", CMD_TYPE_FLOAT,
				 0.0, 0, CONTROL_ATTR_CLIENT));
    register_attribute(Attribute(CONT_SIZE_Y, "y-size", CMD_TYPE_FLOAT,
				 0.0, 0, CONTROL_ATTR_CLIENT));
    register_attribute(Attribute(CONT_SIZE_Z, "z-size", CMD_TYPE_FLOAT,
				 0.0, 0, CONTROL_ATTR_CLIENT));
    register_attribute(Attribute(CONT_EXCHANGE_LINKS, "exchange links", 
				 CMD_TYPE_INT, 0, // link exchange turned off
				 REG_ACQ_ENVIRONMENT, CONTROL_ATTR_USER));
}

/**
 * Execute this Container factory to get a new container object.
 * The vars mapping takes indices: "name", "attributes","attributesAcquired",
 * and "attributesLocked".
 *  
 * @param mapping vars - execute vars, especially the containers name.
 * @return proxy of the newly created container.
 * @author <a href="mailto:astra@upb.de">Thomas Bopp</a>) 
 */
object execute(mapping vars)
{
    object obj;
    string name = vars["name"];
    try_event(EVENT_EXECUTE, CALLER, obj);
    obj = ::object_create(
	name, CLASS_NAME_CONTAINER, 0, vars["attributes"],
	vars["attributesAcquired"], vars["attributesLocked"]);
    run_event(EVENT_EXECUTE, CALLER, obj);
    return obj->this();
}

string get_identifier() { return "Container.factory"; }
string get_class_name() { return "Container"; }
int get_class_id() { return CLASS_CONTAINER; }


