#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "readword.h"
#include "string.h"

#ifdef _WIN32
#  include "stardict.h"
#else
#  include <libgnome/libgnome.h>
#endif

ReadWord::ReadWord()
{	
#ifdef _WIN32
	gchar *filename = g_build_filename(stardict_data_dir, "WyabdcRealPeopleTTS", NULL);
	have_data_file = g_file_test(filename, G_FILE_TEST_EXISTS);
	g_free(filename);
#else
	have_data_file = g_file_test("/usr/share/WyabdcRealPeopleTTS", G_FILE_TEST_EXISTS);
#endif
}

gboolean ReadWord::canRead(const gchar *word)
{	
	gboolean return_val = false;
	if (have_data_file && word && g_ascii_isalpha(word[0])) {
		int n=strlen(word);
		gchar *lowerword = (gchar *)g_malloc(n+1);
		for (int i=0;i<n;i++)
			lowerword[i]= g_ascii_tolower(word[i]);
		lowerword[n] = '\0';
#ifdef _WIN32
		gchar *filename = g_strdup_printf("%s/WyabdcRealPeopleTTS/%c/%s.wav", stardict_data_dir, lowerword[0],lowerword);
#else
		gchar *filename = g_strdup_printf("/usr/share/WyabdcRealPeopleTTS/%c/%s.wav", lowerword[0],lowerword);		
#endif
		return_val = g_file_test(filename, G_FILE_TEST_EXISTS);
		g_free(filename);
		g_free(lowerword);
	}
	return return_val;
}

void ReadWord::read(const gchar *word)
{
	if (have_data_file && word && g_ascii_isalpha(word[0])) {
		int n=strlen(word);
		gchar *lowerword = (gchar *)g_malloc(n+1);
		for (int i=0;i<n;i++)
			lowerword[i]= g_ascii_tolower(word[i]);
		lowerword[n] = '\0';
		gchar *filename;
#ifdef _WIN32
		filename = g_strdup_printf("%s/WyabdcRealPeopleTTS/%c/%s.wav", stardict_data_dir, lowerword[0],lowerword);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
#else
		filename = g_strdup_printf("/usr/share/WyabdcRealPeopleTTS/%c/%s.wav", lowerword[0],lowerword);		
		gnome_sound_play(filename);
#endif
		g_free(filename);
		g_free(lowerword);
	}
}
