/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include "calc.h"
#include "preferences.h"
#include "main.h"
#include "handlers.h"

#include "config.h"

/* The app widget */
GtkWidget *app;



/*
 * file_menu
 * file menu definition
 */
static GnomeUIInfo file_menu[]= {
	{ 
		GNOME_APP_UI_ITEM,
		N_("_Quit"), 
		N_("Quit SNAC Calculator"),
		quit_cb, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_QUIT,
		'Q', 
		GDK_CONTROL_MASK, 
		NULL
	},
	GNOMEUIINFO_END
};


/*
 * edit_menu
 * edit menu definition
 */
static GnomeUIInfo edit_menu[]= {
	{ 
		GNOME_APP_UI_ITEM,
		N_("_Copy"), 
		N_("Copy result to clipboard"),
		ag_edit_copy, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_COPY,
		'C', 
		GDK_CONTROL_MASK,
		NULL
	},
	{
		GNOME_APP_UI_ITEM,
		N_("_Paste"), 
		N_("Paste clipboard contents"),
		ag_edit_paste, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_PASTE,
		'V', 
		GDK_CONTROL_MASK,		
		NULL
	},
	GNOMEUIINFO_SEPARATOR,
	{
		GNOME_APP_UI_ITEM,
		N_("_Preferences..."), 
		N_("Edit SNAC Preferences"),
		ag_edit_preferences, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_PREF,
		'P', 
		GDK_CONTROL_MASK,							 
		NULL
	},
	GNOMEUIINFO_END
};


/*
 * help_menu
 * help menu definition
 */
static GnomeUIInfo help_menu[]=
{
	{
		GNOME_APP_UI_ITEM,
		N_("_About..."), 
		N_("Info about SNAC Calculator"),
		about_cb,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_ABOUT,
		0,
		(GdkModifierType)0,
		NULL
	}, 
	GNOMEUIINFO_END
};



/*
 * main_menu
 * main menu definition
 */
static GnomeUIInfo main_menu[]= 
{
	GNOMEUIINFO_SUBTREE(N_("_File"), file_menu),
	GNOMEUIINFO_SUBTREE(N_("_Edit"), edit_menu),
	GNOMEUIINFO_SUBTREE(N_("_Help"), help_menu),
	GNOMEUIINFO_END
};






/*
 * save_yourself
 * Save the session.
 */  
static gint
save_yourself (GnomeClient             *client, 
	       gint                     phase,
	       GnomeSaveStyle           saveStyle,
               gint                     isShutdown,
	       GnomeInteractStyle       interactStyle,
               gint                     isFast,
	       gpointer                 clientData)
{
 
     
	gchar* args[4] = { "rm", "-r", NULL, NULL };
	
	gnome_config_push_prefix (gnome_client_get_config_prefix (client));
	
	// gnome_config_set... (..)
	// gnome_config_set... (..)
	// gnome_config_set... (..)
	
	
	gnome_config_pop_prefix ();
	
	
	args[2] = gnome_config_get_real_path
		(gnome_client_get_config_prefix (client));
	
	gnome_client_set_discard_command (client, 3, args);
	
	
	return TRUE;
}




/*
 * quit_cb
 * quit the calculator
 */
void 
quit_cb(GtkWidget      *widget, 
	gpointer        data)
{
	/* Free all the memory previously allocated */
	
	/* quit gtk */
	gtk_main_quit ();
}




/* 
 * about_cb
 * display information about the autors 
 */
void 
about_cb(GtkWidget      *widget, 
	 gpointer        data)
{
	GtkWidget *about;
	
	gchar *authors[] = {
		"Matias Mutchinick <matias@seul.org>",
		"Amed Muoz Ramos <amed@spin.com.mx>",
		"Jan Struyf <jan.struyf@cs.kuleuven.ac.be>",
		NULL
	};
	
	about = gnome_about_new ("SNAC", VERSION,
				  "(C) 1999 - 2000 the Free Software Foundation",
				  (gpointer) authors,
				  "SNAC's a Neat Algebraic Calculator\n"
				  " \n"
				  "http://snac.seul.org/\n"
				  "Released under the GNU GPL.",
				  NULL);
	gtk_widget_show (about);
	
}




/*
 * prepare_app
 * Create the application for the calculator, get the prefs
 * from the config file, and init the stack.
 */
void 
prepare_app()
{
  
	GtkWidget *calc;

	
	app = gnome_app_new ("GNOME","SNAC");
	gtk_widget_realize (app);
	gtk_signal_connect (GTK_OBJECT (app),"destroy",
			    GTK_SIGNAL_FUNC (quit_cb), NULL);
	
	gnome_app_create_menus (GNOME_APP (app), main_menu);

	
	calc = ag_create_algnomegebraic();
	gnome_app_set_contents(GNOME_APP(app),calc);
	gtk_signal_connect (GTK_OBJECT(app),"key-press-event",
			    GTK_SIGNAL_FUNC(ag_handle_keyboard_input), NULL); 
	
	gtk_widget_show(calc);
	gtk_widget_show(app);
	
}




/*
 * main      
 * Connect the client and the session manager funcs.
 * Start the application.
 */
gint 
main (int      argc, 
      char    *argv[])
{
	
	GnomeClient   *client;

	bindtextdomain (PACKAGE,GNOMELOCALEDIR);
	textdomain (PACKAGE);	
    	
	gnome_init (PACKAGE, VERSION, argc, argv);
	
	
	client = gnome_master_client ();
	
	gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
			    GTK_SIGNAL_FUNC (save_yourself), NULL);
	gtk_signal_connect (GTK_OBJECT (client), "die",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	
	gnome_config_push_prefix (gnome_client_get_config_prefix (client));
	
	//      ... = gnome_config_get... (..)
	//      ... = gnome_config_get... (..)
	//      ... = gnome_config_get... (..)
	
	gnome_config_pop_prefix ();
	
	
	prepare_app ();
	gtk_main ();
	
	return 0;
}



