/***************************************************************************
    smb4knetworktab.h  -  Displays information about a selected
    network item.
                             -------------------
    begin                : Sam Mr 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KNETWORKTAB_H
#define SMB4KNETWORKTAB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qlistview.h>
#include <qstringlist.h>

// KDE includes
#include <ksqueezedtextlabel.h>

// application specific includes
#include "../core/smb4knetworkitems.h"

class Smb4KNetworkTab : public QWidget
{
  Q_OBJECT

  friend class Smb4KApp;

  public:
    /**
     * The constructor.
     */
    Smb4KNetworkTab( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KNetworkTab();
    /**
     * Clears the widget. It takes an integer between 0 and 2. 0 clears the 
     * complete widget. 1 clears the host and ip entry as well as share 
     * label and entry and type label and entry. 2 only clears the type and 
     * share entry.
     */
    void clear( int depth );
    /**
     * Display the network info passed by the browser widget.
     */
    void display( QListViewItem *item );

  protected slots:
    /** 
     * This slot receives an Smb4KHostItem containing the Server and OS string.
     *
     * @param item  The Smb4KHostItem representing the host about which the information should be displayed.
     */
    void slotInfo( Smb4KHostItem *item );
    /** 
     * This slot is called, if the scanner was killed.
     */
    void slotKilled();
    /**
     * This slot takes the Smb4KHostItem that is emitted by Smb4KIPFinder and compares it
     * with the host that's displayed. If the host name matches and the IP address is not
     * displayed, it will be inserted in the widget.
     *
     * @param item  The Smb4KHostItem emitted by Smb4KIPFinder.
     */
    void slotIPAddress( Smb4KHostItem *item );

  private:
    enum Entries{ Network = 0, Type = 1, IP = 2, Comment = 3 };
    QLabel *m_workgroupLabel;
    KSqueezedTextLabel *m_workgroup;
    QLabel *m_masterLabel;
    KSqueezedTextLabel *m_master;
    QLabel *m_hostLabel;
    KSqueezedTextLabel *m_host;
    QLabel *m_osLabel;
    KSqueezedTextLabel *m_os;
    QLabel *m_serverLabel;
    KSqueezedTextLabel *m_server;
    QLabel *m_shareLabel;
    KSqueezedTextLabel *m_share;
    QLabel *m_typeLabel;
    KSqueezedTextLabel *m_type;
    QListViewItem *m_current;
    QLabel *m_ipLabel;
    KSqueezedTextLabel *m_ip;
};

#endif
