/***************************************************************************
    smb4kauthoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>

// KDE includes
#include <kmessagebox.h>
#include <kiconloader.h>
#include <klocale.h>

// application specific includes
#include "smb4kauthoptions.h"

Smb4KAuthOptions::Smb4KAuthOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );
  //
  // Default Authentication
  //
  QWidget *w1 = new QWidget( this );
  QGridLayout *w1grid = new QGridLayout( w1 );
  w1grid->setSpacing( 10 );

  QVGroupBox *box1 = new QVGroupBox( i18n( "Default Login" ), w1 );
  box1->setInsideMargin( 10 );

  QLabel *description1 = new QLabel( i18n( "This login will be used, if none has been defined for a share." ), box1 );
  description1->setTextFormat( Qt::RichText );

  m_defaultAuth = new QCheckBox( i18n( "Use default login." ), box1 );

  m_authWidget = new QWidget( box1 );
  QGridLayout *box1Grid = new QGridLayout( m_authWidget );
  box1Grid->setSpacing( 10 );
  
  QSpacerItem *spacer1 = new QSpacerItem( 25, 0, QSizePolicy::Fixed, QSizePolicy::Fixed );
  QLabel *login = new QLabel( i18n( "User:" ), m_authWidget );
  m_defaultLogin = new KLineEdit( QString::null, m_authWidget );
  m_defaultLogin->setMinimumWidth( 150 );
  QLabel *passwd = new QLabel( i18n( "Password:" ), m_authWidget );
  m_defaultPasswd = new KLineEdit( QString::null, m_authWidget );
  m_defaultPasswd->setMinimumWidth( 150 );
  m_defaultPasswd->setEchoMode( KLineEdit::Password );
  
  box1Grid->addMultiCell( spacer1, 0, 1, 0, 0, 0 );
  box1Grid->addWidget( login, 0, 1 );
  box1Grid->addWidget( m_defaultLogin, 0, 2 );
  box1Grid->addWidget( passwd, 1, 1 );
  box1Grid->addWidget( m_defaultPasswd, 1, 2 );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  w1grid->addWidget( box1, 0, 0, 0 );
  w1grid->addItem( spacer2, 1, 0 );

  addTab( w1, i18n( "General" ) );


  //
  // Authentication for single shares.
  //
  QWidget *w2 = new QWidget( this );
  QGridLayout *w2grid = new QGridLayout( w2 );
  w2grid->setSpacing( 10 );

  QVGroupBox *box2 = new QVGroupBox( i18n( "Input" ), w2 );
  box2->setInsideSpacing( 10 );
  
//  QLabel *description2 = new QLabel( i18n( "Here you should enter password protected hosts and shares, that you want to log in." ), box2 );
//  description2->setTextFormat( Qt::RichText );

  QWidget *wdg2 = new QWidget( box2 );
  QGridLayout *wdg2Grid = new QGridLayout( wdg2 );
  wdg2Grid->setSpacing( 10 );

  // The line edits:
  QLabel *a = new QLabel( i18n( "Workgroup:" ), wdg2 );
  m_workgroupEdit = new KLineEdit( QString::null, wdg2 );
  m_workgroupEdit->setMinimumWidth( 150 );

  QLabel *b = new QLabel( i18n( "Host:" ), wdg2 );
  m_hostEdit = new KLineEdit( QString::null, wdg2 );
  m_hostEdit->setMinimumWidth( 150 );

  m_oneShare = new QCheckBox( i18n( "Share:" ), wdg2 );
  m_shareEdit = new KLineEdit( QString::null, wdg2 );
  m_shareEdit->setEnabled( false );
  m_shareEdit->setMinimumWidth( 150 );

  QLabel *c = new QLabel( i18n( "User:" ), wdg2 );
  m_loginEdit = new KLineEdit( QString::null, wdg2 );
  m_loginEdit->setMinimumWidth( 150 );

  QLabel *d = new QLabel( i18n( "Password:" ), wdg2 );
  m_passwdEdit = new KLineEdit( QString::null, wdg2 );
  m_passwdEdit->setEchoMode( KLineEdit::Password );
  m_passwdEdit->setMinimumWidth( 150 );

  // Set the tab order.
  setTabOrder( m_workgroupEdit, m_hostEdit );
  setTabOrder( m_hostEdit, m_oneShare );
  setTabOrder( m_oneShare, m_shareEdit );
  setTabOrder( m_shareEdit, m_loginEdit );
  setTabOrder( m_loginEdit, m_passwdEdit );

  QWidget *buttons1 = new QWidget( wdg2 );
  QGridLayout *buttons1Layout = new QGridLayout( buttons1 );
  buttons1Layout->setSpacing( 10 );
  QSpacerItem *spacer3 = new QSpacerItem( 10, 10, QSizePolicy::Expanding, QSizePolicy::Preferred );
  m_add = new KPushButton( i18n( "A&dd" ), buttons1 );
  m_clear = new KPushButton( i18n( "C&lear" ), buttons1 );
  buttons1Layout->addItem( spacer3, 0, 0 );
  buttons1Layout->addWidget( m_add, 0, 1 );
  buttons1Layout->addWidget( m_clear, 0, 2 );

  wdg2Grid->addWidget( a, 0, 0 );
  wdg2Grid->addWidget( m_workgroupEdit, 0, 1 );
  wdg2Grid->addWidget( b, 1, 0 );
  wdg2Grid->addWidget( m_hostEdit, 1, 1 );
  wdg2Grid->addWidget( m_oneShare, 2, 0 );
  wdg2Grid->addWidget( m_shareEdit, 2, 1 );
  wdg2Grid->addWidget( c, 0, 2 );
  wdg2Grid->addWidget( m_loginEdit, 0, 3 );
  wdg2Grid->addWidget( d, 1, 2 );
  wdg2Grid->addWidget( m_passwdEdit, 1, 3 );
  wdg2Grid->addMultiCellWidget( buttons1, 2, 2, 2, 3 );

  m_loginData = new KListView( w2 );
  m_loginData->addColumn( i18n( "Workgroup" ), -1 );
  m_loginData->addColumn( i18n( "Host" ), -1 );
  m_loginData->addColumn( i18n( "Share" ), -1 );
  m_loginData->addColumn( i18n( "User" ), -1 );
  m_loginData->addColumn( QString::null, 0 );
  m_loginData->setAllColumnsShowFocus( true );

  w2grid->addWidget( box2, 0, 0, 0 );
  w2grid->addWidget( m_loginData, 1, 0, 0 );

  addTab( w2, i18n( "Hosts and Shares" ) );

  m_edit = false;

  connect( m_add, SIGNAL( clicked() ), SLOT( slotAddClicked() ) );
  connect( m_clear, SIGNAL( clicked() ), SLOT( slotClearClicked() ) );
  connect( m_loginData, SIGNAL( rightButtonClicked( QListViewItem *, const QPoint &, int ) ), SLOT( slotContextMenu( QListViewItem *, const QPoint &, int ) ) );
  connect( m_oneShare, SIGNAL( stateChanged( int ) ), SLOT( slotShareStateChanged( int ) ) );
  connect( m_defaultAuth, SIGNAL( stateChanged( int ) ), SLOT( slotAuthDataStateChanged( int ) ) );
}


Smb4KAuthOptions::~Smb4KAuthOptions()
{
}


void Smb4KAuthOptions::clear()
{
  m_workgroupEdit->clear();
  m_hostEdit->clear();
  m_loginEdit->clear();
  m_passwdEdit->clear();
  m_shareEdit->clear();
  m_shareEdit->setEnabled( false );
  m_oneShare->setChecked( false );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KAuthOptions::slotAddClicked()
{
  bool wg = !m_workgroupEdit->text().stripWhiteSpace().isEmpty();
  bool hst = !m_hostEdit->text().stripWhiteSpace().isEmpty();
  bool one = m_oneShare->isChecked();
  bool sh = !m_shareEdit->text().stripWhiteSpace().isEmpty();
  bool lgn = !m_loginEdit->text().stripWhiteSpace().isEmpty();

  if ( m_edit )
  {
    if ( wg && hst && ( ( one && sh ) || !one ) && lgn )
    {
      m_loginData->currentItem()->setText( 0, m_workgroupEdit->text().stripWhiteSpace().upper() );
      m_loginData->currentItem()->setText( 1, m_hostEdit->text().stripWhiteSpace().upper() );

      if ( !one )
        m_loginData->currentItem()->setText( 2, "*" );
      else if ( one && sh )
        m_loginData->currentItem()->setText( 2, m_shareEdit->text().stripWhiteSpace() );

      m_loginData->currentItem()->setText( 3, m_loginEdit->text().stripWhiteSpace() );
      m_loginData->currentItem()->setText( 4, m_passwdEdit->text().stripWhiteSpace() );

      clear();
      m_workgroupEdit->setFocus();
      m_edit= false;
    }
    else
    {
      QString msg = i18n( "You left the following entries blank:\n%1\nPlease fill them out." );

      QString entries;

      if ( !wg )
      {
        entries.append( i18n( "Workgroup" ) );
        entries.append( " - " );
      }

      if ( !hst )
      {
        entries.append( i18n( "Host" ) );
        entries.append( " - " );
      }

      if ( one && !sh )
      {
        entries.append( i18n( "Share" ) );
        entries.append( " - " );
      }

      if ( !lgn )
        entries.append( i18n( "User" ) );

      entries = entries.stripWhiteSpace();

      if ( entries.endsWith( "-" ) )
        entries.truncate( entries.length()-2 );

      KMessageBox::error( this, msg.arg( entries ) );
    }
  }
  else
  {
    if ( wg && hst && ( ( one && sh ) || !one ) && lgn )
    {
      bool foundEntry = false;

      for ( QListViewItem *item = m_loginData->findItem( m_hostEdit->text().stripWhiteSpace(), 1, Qt::ExactMatch ); item ; item = item->nextSibling() )
      {
        if ( m_workgroupEdit->text().stripWhiteSpace().upper() == item->text( 0 ) && ( m_shareEdit->text().stripWhiteSpace().upper() == item->text( 2 ) || ( item->text( 2 ) == "*" && !m_oneShare->isChecked() ) ) )
        {
          if ( KMessageBox::warningYesNo( this, i18n( "Authentication data for this share is already in the list.\nDo you want to replace it?" ) ) == KMessageBox::Yes )
          {
            item->setText( 0, m_workgroupEdit->text().stripWhiteSpace().upper() );
            item->setText( 1, m_hostEdit->text().stripWhiteSpace().upper() );

            if ( !one )
              item->setText( 2, "*" );
            else if ( one && sh )
              item->setText( 2, m_shareEdit->text().stripWhiteSpace() );

            item->setText( 3, m_loginEdit->text().stripWhiteSpace() );
            item->setText( 4, m_passwdEdit->text().stripWhiteSpace() );

            clear();
            m_workgroupEdit->setFocus();
          }
          else
          {
            clear();
            m_workgroupEdit->setFocus();
          }

          foundEntry = true;
          break;
        }
      }

      if ( !foundEntry )
      {
        QListViewItem *newItem = new QListViewItem( m_loginData );
        newItem->setText( 0, m_workgroupEdit->text().stripWhiteSpace().upper() );
        newItem->setText( 1, m_hostEdit->text().stripWhiteSpace().upper() );

        if ( !one )
          newItem->setText( 2, "*" );
        else if ( one && sh )
          newItem->setText( 2, m_shareEdit->text().stripWhiteSpace() );

        newItem->setText( 3, m_loginEdit->text().stripWhiteSpace() );
        newItem->setText( 4, m_passwdEdit->text().stripWhiteSpace() );

        clear();
        m_workgroupEdit->setFocus();
      }
    }
    else
    {
      QString msg = i18n( "You left the following entries blank:\n%1\nPlease fill them out." );

      QString entries;

      if ( !wg )
      {
        entries.append( i18n( "Workgroup" ) );
        entries.append( " - " );
      }

      if ( !hst )
      {
        entries.append( i18n( "Host" ) );
        entries.append( " - " );
      }

      if ( one && !sh )
      {
        entries.append( i18n( "Share" ) );
        entries.append( " - " );
      }

      if ( !lgn )
        entries.append( i18n( "User" ) );

      entries = entries.stripWhiteSpace();

      if ( entries.endsWith( "-" ) )
        entries.truncate( entries.length()-2 );

      KMessageBox::error( this, msg.arg( entries ) );
    }
  }
}


void Smb4KAuthOptions::slotClearClicked()
{
  clear();
  m_workgroupEdit->setFocus();
}


void Smb4KAuthOptions::slotRemoveClicked()
{
  if ( m_loginData->currentItem() != 0 && m_loginData->currentItem()->isSelected() )
    delete m_loginData->currentItem();
}


void Smb4KAuthOptions::slotEditClicked()
{
  m_edit = true;

  if ( m_loginData->currentItem() )
  {
    m_workgroupEdit->setText( m_loginData->currentItem()->text( 0 ) );
    m_hostEdit->setText( m_loginData->currentItem()->text( 1 ) );

    if ( m_loginData->currentItem()->text( 2 ) == "*" )
    {
      m_oneShare->setChecked( false );
      m_shareEdit->clear();
    }
    else
    {
      m_oneShare->setChecked( true );
      m_shareEdit->setText( m_loginData->currentItem()->text( 2 ) );
    }

    m_loginEdit->setText( m_loginData->currentItem()->text( 3 ) );
    m_passwdEdit->setText( m_loginData->currentItem()->text( 4 ) );
  }
}


void Smb4KAuthOptions::slotContextMenu( QListViewItem *item, const QPoint &point, int col )
{
  m_col = col;
  m_menu = new KPopupMenu( this );

  QIconSet edit( SmallIcon( "edit" ), QIconSet::Automatic );
  m_menu->insertItem( edit, i18n( "Edit" ), this, SLOT( slotEditClicked() ), 0, Edit, 1 );
  
  QIconSet remove( SmallIcon( "remove" ), QIconSet::Automatic );
  m_menu->insertItem( remove, i18n( "Remove" ), this, SLOT( slotRemoveClicked() ), 0, Remove, 2 );
  
  if ( item && col < m_loginData->columns() )
  {
    m_menu->setItemEnabled( Remove, true );
    m_menu->setItemEnabled( Edit, true );
  }
  else
  {
    m_menu->setItemEnabled( Remove, false );
    m_menu->setItemEnabled( Edit, false );
  }
  m_menu->exec( point, 0 );
}


void Smb4KAuthOptions::slotShareStateChanged( int state )
{
  if ( state == QCheckBox::On )
    m_shareEdit->setEnabled( true );
  else if ( state == QCheckBox::Off )
    m_shareEdit->setEnabled( false );
}


void Smb4KAuthOptions::slotAuthDataStateChanged( int state )
{
  if ( state == QCheckBox::On )
    m_authWidget->setEnabled( true );
  else if ( state == QCheckBox::Off )
    m_authWidget->setEnabled( false );
}


#include "smb4kauthoptions.moc"
