/*
    This file is part of the sly ident daemon (slidentd).  slidentd 
    was written by Sean Hunter <sean@uncarved.com> as a minimal 
    RFC1413 (ident) daemon.

    slidentd is copyright (c) 2001 Uncarved Systems Ltd.

    slidentd is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License 
    as published by the Free Software Foundation.

    slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    in the file COPYING along with slidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "slid_fmt_xlong0.h"
#include <fmt.h>

/* Code adapted from Felix von Leitner's libowfat */

unsigned int
slid_fmt_xlong0(char *dest, unsigned long i, unsigned int pad)
{
	register unsigned int len;
	register unsigned long tmp;
	char *orig = dest;

	/* first count the number of bytes needed */
	for (len = 1, tmp = i; tmp > 9; ++len) {
		tmp /= 16;
	}

	/* now see if we need to pad */
	if (dest) {
		while (len < pad) {
			*dest = '0';
			++dest;
			++len;
		}

		fmt_xlong(dest, i);
		for (len = 0; len < pad; len++) {
			if (orig[len] >= 'a' && orig[len] <= 'f') {
				orig[len] = orig[len] - 'a' + 'A';
			}
		}

		return len;
	} else {
		return (len < pad ? pad : len);
	}
}
