/* # skkinput (Simple Kana-Kanji Input)
 * XimpP.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef XimpP_h
#define XimpP_h

#include "Ximp.h"
#include "attrs.h"
#include <X11/CoreP.h>

enum {
  WINDOW_TYPE_SEPARATE = 0,
  WINDOW_TYPE_OVERTHESPOT,
  WINDOW_TYPE_OFFTHESPOT,
} ;

enum {
  EVENT_NO_SHORINASHI = 0,
  EVENT_HA_INPUTONLY,
  EVENT_HA_FOCUS_KARA,
} ;

typedef struct {
  String	localename ;
  String	servername ;
  String	conversionStartKey ;	/* ѴϤΰȤʤ륭*/
  unsigned long	icid, property_id ;
  Boolean	 ximp_defaultServer ;

  XtCallbackList setupInputWindowCallback ;
  XtCallbackList serverCloseCallback ;

  /* ѴѤ륢ȥĤ¿Ǥ͡*/
  Atom ximp_selection1, ximp_selection2 ;
  Atom compound_text ;
  Atom ximp_version, ximp_inputstyle, ximp_keys, ximp_servername ;
  Atom ximp_serverversion, ximp_vendorname, ximp_extensions ;
  Atom ximp_protocol, ximp_focus, ximp_preedit, ximp_status ;
  Atom ximp_preeditfont, ximp_statusfont, ximp_extbackfront ;

  /* ġ */
  struct ConvAttrsMesg camsg ;

  XDestroyWindowEvent *destroyWindowEvent ;

  int jisyo_dirty ;
  unsigned int status_width ;

  /* XIMP Protocol ǽƤ륯饤ȤΥꥹȡ*/
  struct XimpClient	*client_list ;
} XimpPart ;

/* դ뤤󤹤󤹡 */
typedef struct _XimpRec {
  CorePart 	core ;
  XimpPart	ximp ;
} XimpRec ;

/* New fields for the My widget class record */
typedef struct {
  int dummy ;
} XimpClassPart ;

/* դ뤯餹 */
typedef struct _XimpClassRec {
  CoreClassPart		core_class ;
  XimpClassPart		ximp_class ;
} XimpClassRec ;

/* 餹ݤ󤿡 */
extern XimpClassRec ximpClassRec ;

#endif
