/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_MISC_H__
#define __SG_MISC_H__

void sg_entry_set_numeric			(GtkEntry *entry, gint digits);
void sg_entry_cancel_space			(GtkEntry *entry);
void sg_editable_insert_text     		(GtkEditable *editable,
                             			 const gchar *new_text,
                             			 gint         new_text_length,
                            			 gint        *position,
                             			 gpointer data);
void sg_editable_insert_digits   		(GtkEditable *editable,
                             			 const gchar *new_text,
                             			 gint         new_text_length,
                             			 gint        *position,
                             			 gpointer data);
void sg_combo_set_items				(GtkCombo *combo, 
						 gchar **labels);
void sg_color_combo_changed			(GtkColorCombo *combo, 
						 gint selection, gchar *name);
void sg_color_combo_init			(GtkColorCombo *color_combo, 
						 GdkColor new_color);


#endif /* __SG_MISC_H__ */

