/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_edit_dialog.h"
#include "sg_dataset.h"
#include "sg.h"

#define DATASET_NAME_LENGTH 100

static gint toggle_selection = 0;
static gint the_layer = 0;
static SGdataStyle data_style;
static SGdataset *the_dataset = NULL;
static GtkWidget *matrix_list;
static GtkWidget* dialog = NULL;
static GtkWidget *toggle_combo;

SGdataset *
sg_edit_3d_update()
{/* the widget is needed to use this func as callback */

  GList *selection;
  SGworksheet *matrix = NULL;
  gint toggle_selection;
  gint row;

  selection = GTK_CLIST(matrix_list)->selection;
  if(!selection) return NULL;

  row = GPOINTER_TO_INT(selection->data);
  matrix = (SGworksheet *)gtk_clist_get_row_data(GTK_CLIST(matrix_list), row);

  if(!matrix) return NULL;

  if(!the_dataset){

    toggle_selection = sg_toggle_data_get_selection(toggle_combo);

    if(the_layer == SG_LAYER_3D){
      switch(toggle_selection){
        case 1:
          data_style = SG_STYLE_SURFACE;
          the_dataset = sg_dataset_new(data_style);
          break;
        case 2:
          data_style = SG_STYLE_CSURFACE;
          the_dataset = sg_dataset_new(data_style);
          break;
        case 0:
        default:
          data_style = SG_STYLE_LPOINTS;
          the_dataset = sg_dataset_new(data_style);
          the_dataset->real_data->symbol.symbol_type = GTK_PLOT_SYMBOL_SQUARE;
          the_dataset->real_data->line.line_style = GTK_PLOT_LINE_NONE;
          break;
      }
    } else {
      switch(toggle_selection){
        case 1:
          data_style = SG_STYLE_DMAP;
          the_dataset = sg_dataset_new(data_style);
          break;
        case 2:
          data_style = SG_STYLE_BUBBLES; 
          the_dataset = sg_dataset_new(data_style);
          the_dataset->real_data->symbol.symbol_type = GTK_PLOT_SYMBOL_SQUARE;
          the_dataset->real_data->line.line_style = GTK_PLOT_LINE_NONE;
          the_dataset->real_data->iterator_mask = SG_STYLE_BUBBLES_MASK;
          break;
        case 3:
          data_style = SG_STYLE_COLORS; 
          the_dataset = sg_dataset_new(data_style);
          the_dataset->real_data->symbol.symbol_type = GTK_PLOT_SYMBOL_SQUARE;
          the_dataset->real_data->line.line_style = GTK_PLOT_LINE_NONE;
          the_dataset->real_data->iterator_mask = SG_STYLE_COLORS_MASK - GTK_PLOT_DATA_A;
          break;
        case 0:
        default:
          data_style = SG_STYLE_CONTOUR;
          the_dataset = sg_dataset_new(data_style);
          break;
      }
    }
  }
  sg_dataset_set_matrix(the_dataset, matrix); 

  return the_dataset;
}

GtkWidget *
sg_edit_3d_dialog (SGdataset *dataset, SGlayerType layer_type)
{
  GtkWidget *frame, *vbox;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *box, *sw;
  GtkWidget *entries_box;
  GList *list;
  GtkWidget *item;
  SGworksheet *worksheet;
  gint i;
  gint toggle_selection;

  the_dataset = dataset;
  the_layer = layer_type;

  if(dataset){
    data_style = dataset->style;
  } else {
    data_style = (SGdataStyle)0;
  }

  /* Create widgets */

  vbox = gtk_vbox_new(FALSE, 5);

/*********************************************************************/

  box = gtk_hbox_new(TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), box, FALSE, FALSE, 0);

  label = gtk_label_new("Dataset Style:");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);

  if(layer_type == SG_LAYER_3D)
    toggle_combo = sg_toggle_data_new(4);
  else
    toggle_combo = sg_toggle_data_new(5);

  gtk_box_pack_start (GTK_BOX (box), toggle_combo, FALSE, FALSE, 0);

  switch(data_style){
    case SG_STYLE_SURFACE:
      toggle_selection = 1;
      break;
    case SG_STYLE_CSURFACE:
      toggle_selection = 2;
      break;
    case SG_STYLE_LPOINTS:
    case SG_STYLE_BUBBLES:
    default:
      toggle_selection = 0;
      break;
  }
  sg_toggle_data_init(toggle_combo, toggle_selection);

  if(the_dataset){
    gtk_widget_set_sensitive(toggle_combo, FALSE);
  }else{
    gtk_widget_set_sensitive(toggle_combo, TRUE);
  }

/*********************************************************************/
  frame = gtk_frame_new("Select Matrix");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  entries_box = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(entries_box), 5);
  gtk_container_add (GTK_CONTAINER (frame), entries_box);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_set_usize(sw, 240, 160);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_box_pack_start (GTK_BOX (entries_box), sw, FALSE, FALSE, 0);

  matrix_list = gtk_clist_new(1);
  gtk_container_add(GTK_CONTAINER(sw), matrix_list);

  list = worksheets;
  while(list){
   SGworksheet *worksheet;
   
   worksheet = (SGworksheet *)list->data;
   if(worksheet->mode == SG_MODE_MATRIX){
     gtk_clist_append(GTK_CLIST(matrix_list), &worksheet->name);
     gtk_clist_set_row_data(GTK_CLIST(matrix_list), GTK_CLIST(matrix_list)->rows-1, list->data);
     if(dataset && dataset->worksheet == worksheet){
       gtk_clist_select_row(GTK_CLIST(matrix_list), GTK_CLIST(matrix_list)->rows-1, 0);
     }
   }
   list = list->next;
  }

/********************************************************************/
  return vbox;
}

