/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DIALOGS_H__
#define __SG_DIALOGS_H__

typedef enum {
	DESTROY_CLICKED = -1,
	NO_CLICKED  = FALSE,
	YES_CLICKED = TRUE,
	CANCEL_CLICKED,
} SGdialogClick;


typedef enum {
      COLUMNS_DIALOG,
      MATRIX_DIALOG,
      FUNCTIONS_DIALOG,
      PYTHON_DIALOG
} SGdialog;

extern gchar *file_path;
extern gchar *line_styles[];
extern gchar *border_styles[];
extern gchar *connectors[];
extern gchar *symbol_styles[];

void	sg_dialog_new		(GtkWidget *widget);
void	sg_dialog_kill		(GtkWidget *widget);

void	sg_dialogs_destroy	(GtkWidget *widget);
void	sg_dialogs_init		(void);

#include "sg_arrange_dialog.h"
#include "sg_axis_dialog.h"
#include "sg_column_dialog.h"
#include "sg_convert_dialog.h"
#include "sg_dataset_dialog.h"
#include "sg_edit_dialog.h"
#include "sg_ellipse_dialog.h"
#include "sg_file_dialog.h"
#include "sg_formula_dialog.h"
#include "sg_frame_dialog.h"
#include "sg_function_dialog.h"
#include "sg_grids_dialog.h"
#include "sg_import_dialog.h"
#include "sg_labels_dialog.h"
#include "sg_layer_dialog.h"
#include "sg_legends_dialog.h"
#include "sg_line_dialog.h"
#include "sg_logo_dialogs.h"
#include "sg_matrix_dialog.h"
#include "sg_misc_dialogs.h"
#include "sg_new_data_dialog.h"
#include "sg_page_dialog.h"
#include "sg_planes_dialog.h"
#include "sg_preferences_dialog.h"
#include "sg_rectangle_dialog.h"
#include "sg_style_dialog.h"
#include "sg_text_dialog.h"
#include "sg_title_dialog.h"
#include "sg_xy_formula_dialog.h"

#endif /* __SG_DIALOGS_H__ */
