#ifndef STANDARD_PACKAGE_HH
#define STANDARD_PACKAGE_HH

// Copyright (c) 1996-2001 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING
// OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found
// in the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Krishnan Subramani
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam
//          Radharamanan Radhakrishnan
//          Swaminathan Subramanian
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_PackageDeclaration.hh"

class IIR_EnumerationSubtypeDefinition;
class IIR_EnumerationLiteralList;
class IIR_EnumerationLiteral;
class IIR_IntegerSubtypeDefinition;
class IIR_FloatingSubtypeDefinition;
class IIR_PhysicalSubtypeDefinition;
class IIR_ArraySubtypeDefinition;
class IIR_AttributeDeclaration;
class IIR_TypeDeclaration;
class IIR_SubtypeDeclaration;
class IIR_FunctionDeclaration;
class IIR_TypeDefinition;
class IIR_ScalarTypeDefinition;
class IIR_PhysicalUnit;
class IIR_LibraryDeclaration;
class IIR_AccessSubtypeDefinition;

class StandardPackage : public IIR_PackageDeclaration {
public:

  // Boolean has to be defined before anything else
  static IIR_EnumerationLiteral *get_false_literal();
  static IIR_EnumerationLiteral *get_true_literal();
  static IIR_EnumerationSubtypeDefinition *get_boolean_type();
  static IIR_TypeDeclaration *get_boolean_decl();

  // Here are the builtin universal types.
  static IIR_IntegerSubtypeDefinition *get_savant_universal_integer();
  static IIR_FloatingSubtypeDefinition *get_savant_universal_real();

  // These types represent those declared in std.standard.
  static IIR_EnumerationSubtypeDefinition *get_bit_type();
  static IIR_TypeDeclaration *get_bit_decl();

  static IIR_IntegerSubtypeDefinition *get_integer_type();
  static IIR_TypeDeclaration *get_integer_decl();

  static IIR_EnumerationSubtypeDefinition *get_character_type();
  static IIR_TypeDeclaration *get_character_decl();

  static IIR_IntegerSubtypeDefinition *get_positive_type();
  static IIR_SubtypeDeclaration *get_positive_decl();

  static IIR_ArraySubtypeDefinition *get_string_type();
  static IIR_TypeDeclaration *get_string_decl();

  static IIR_EnumerationSubtypeDefinition *get_severity_level_type();
  static IIR_TypeDeclaration *get_severity_level_decl();

  static IIR_FloatingSubtypeDefinition *get_real_type();
  static IIR_TypeDeclaration *get_real_decl();

  static IIR_PhysicalSubtypeDefinition *get_time_type();
  static IIR_TypeDeclaration *get_time_decl();

  static IIR_PhysicalSubtypeDefinition *get_delay_length_type();
  static IIR_SubtypeDeclaration *get_delay_length_decl();

  static IIR_IntegerSubtypeDefinition *get_natural_type();
  static IIR_SubtypeDeclaration *get_natural_decl();

  static IIR_ArraySubtypeDefinition *get_bit_vector_type();
  static IIR_TypeDeclaration *get_bit_vector_decl();

  static IIR_EnumerationSubtypeDefinition *get_file_open_kind_type();
  static IIR_TypeDeclaration *get_file_open_kind_decl();

  static IIR_EnumerationSubtypeDefinition *get_file_open_status_type();
  static IIR_TypeDeclaration *get_file_open_status_decl();

  static IIR_AttributeDeclaration *get_foreign_decl();
  static IIR_FunctionDeclaration *get_now_decl();

  static IIR_LibraryDeclaration *get_std_decl();
  static StandardPackage *get_std_standard_decl();

  // This is a Savant specific extension
  static IIR_AccessSubtypeDefinition *get_savant_null_type_definition();


  ~StandardPackage(){}

  static void fill_list( IIR_DeclarationList * );
  
private:
  StandardPackage();

  static IIR_IntegerSubtypeDefinition *init_integer_type();
  static IIR_IntegerSubtypeDefinition *init_positive_type();
  static IIR_IntegerSubtypeDefinition *init_natural_type();
  static IIR_FloatingSubtypeDefinition *init_real_type();
  static IIR_EnumerationLiteral *init_false_literal();
  static IIR_EnumerationLiteral *init_true_literal();
  static IIR_TypeDeclaration *init_boolean_decl();
  static IIR_EnumerationSubtypeDefinition *init_boolean_type();
  static IIR_TypeDeclaration *init_bit_decl();
  static IIR_EnumerationSubtypeDefinition *init_bit_type();
  static IIR_TypeDeclaration *init_character_decl();
  static IIR_EnumerationSubtypeDefinition *init_character_type();
  static IIR_TypeDeclaration *init_severity_level_decl();
  static IIR_EnumerationSubtypeDefinition *init_severity_level_type();
  static IIR_TypeDeclaration *init_file_open_kind_decl();
  static IIR_EnumerationSubtypeDefinition *init_file_open_kind_type();
  static IIR_TypeDeclaration *init_file_open_status_decl();
  static IIR_EnumerationSubtypeDefinition *init_file_open_status_type();
  static IIR_TypeDeclaration *init_integer_decl( );
  static IIR_TypeDeclaration *init_real_decl( );
  static IIR_TypeDeclaration *init_string_decl( );
  static IIR_TypeDeclaration *init_bit_vector_decl();
  static IIR_PhysicalSubtypeDefinition *init_time_type();
  static IIR_SubtypeDeclaration *init_delay_length_decl();
  static IIR_PhysicalSubtypeDefinition *init_delay_length_type();
  static IIR_AttributeDeclaration *init_foreign_decl();
  static IIR_FunctionDeclaration *init_now_decl();
  static IIR_LibraryDeclaration *init_std_decl();
  static IIR_AccessSubtypeDefinition *init_null_type();

  static IIR_TypeDeclaration *init_type_decl( char *, IIR_TypeDefinition * );  
  static IIR_SubtypeDeclaration *init_subtype_decl( char *, IIR_TypeDefinition * );  

  static IIR_EnumerationSubtypeDefinition *init_enumeration_type( const char * const literals[] );

  static IIR_EnumerationSubtypeDefinition *init_enumeration_type( IIR_EnumerationLiteralList *literals );

  static IIR_ArraySubtypeDefinition *
  init_unconstrained_array_type(  IIR_ScalarTypeDefinition *index_type,
				  IIR_TypeDefinition *element_type,
				  IIR_TypeDeclaration *type_decl );

  static IIR_IntegerSubtypeDefinition *
  init_integer_type( int left_bound, int right_bound );

  static IIR_FloatingSubtypeDefinition *
  init_real_type( double left_bound, double right_bound );
  
  static void set_locator_info( IIR * );
  static IIR_PhysicalUnit *find_unit( char *name, IIR_PhysicalSubtypeDefinition *physical_type );

  struct unit {
    char *unit_name;
    int multiplier;
    char *base_unit;
  };

  static IIR_PhysicalSubtypeDefinition *
  init_physical_type( int,
		      int,
		      char *,
		      struct unit[] );

  static StandardPackage *init_std_standard();

  static int STD_INT_MAX();
  static int STD_INT_MIN();
  static double REAL_MAX();
  static double REAL_MIN();  
  static IIR_Identifier *get_file_info();
  static char *get_file_string();

  static IIR_EnumerationLiteralList *build_literal_list( const char *const literals[] );
};

#endif
