
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "IIRScram_WaveformElement.hh"
#include "IIR_WaveformElement.hh"
#include "IIR_List.hh"
#include "IIR_Declaration.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_AboveAttribute.hh"
#include "StandardPackage.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_WaveformElement::~IIRScram_WaveformElement() {}

void 
IIRScram_WaveformElement::_publish_vhdl(ostream &_vhdl_out) {
  get_value()->_publish_vhdl(_vhdl_out);

  if (get_time() != NULL) {
    _vhdl_out << " after ";
    get_time()->_publish_vhdl(_vhdl_out);
  }
}

IIR_Boolean
IIRScram_WaveformElement::_is_null_transaction() {
  int retval = -1;
  if(get_value()->_is_string_literal() == TRUE) {
    ASSERT(get_value()->get_kind() == IIR_STRING_LITERAL);
    IIR_StringLiteral* string_lit = (IIR_StringLiteral*)get_value();
    retval = IIR_StringLiteral::_cmp(string_lit, "null");
    if(retval == 0) {
      return TRUE;
    }
  }
  return FALSE;
}

void 
IIRScram_WaveformElement::_publish_cc_lvalue( published_file &_cc_out ) {
  ASSERT( _is_resolved() == TRUE );
  // Publish source
  if(_is_null_transaction() == FALSE) {
    if(get_value()->get_kind() == IIR_SLICE_NAME) {
      get_value()->_get_prefix_declaration()->_publish_cc_lvalue( _cc_out );
    } 
    else {
      get_value()->_publish_cc_lvalue( _cc_out );
    }
    _cc_out << "," << NL();
  }
  // Publish delay time.
  if( get_time() != NULL ){
    get_time()->_publish_cc_lvalue( _cc_out );
    _cc_out << ",";
  }
  else {
    _cc_out << "SAVANT_ZERO_TIME, ";
  }
  _cc_out << NL();
}

void
IIRScram_WaveformElement::_publish_cc_bounds( published_file &_cc_out ) {
  get_value()->_publish_cc_bounds( _cc_out );
}

void
IIRScram_WaveformElement::_type_check( set<IIR_TypeDefinition> *context_set ) {
  get_value()->_type_check( context_set );
  if( get_time() != NULL ){
    IIR_TypeDefinition *time_rval = StandardPackage::get_time_type();
    set_time( get_time()->_semantic_transform( time_rval ));
    get_time()->_type_check( time_rval );
    set_time( get_time()->_rval_to_decl( time_rval ));
  }
}

set<IIR_TypeDefinition>*
IIRScram_WaveformElement::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ) {
  return get_value()->_get_rval_set(constraint_function);
}

IIR *
IIRScram_WaveformElement::_semantic_transform( set<IIR_TypeDefinition> *context_set ){
  set_value( get_value()->_semantic_transform( context_set ) );

  return (IIR *)this;
}

IIR *
IIRScram_WaveformElement::_rval_to_decl( IIR_TypeDefinition *my_rval ){
  set_value( get_value()->_rval_to_decl( my_rval ) );
  
  return this;
}

ostream &
IIRScram_WaveformElement::_print( ostream &os ) {
  os << *get_value();

  if (get_time() != NULL) {
    os << " after ";
    os << *get_time();
    os << " ";
  }

  return os;
}

void
IIRScram_WaveformElement::_get_list_of_input_signals( set<IIR> *list ){
  get_value()->_get_list_of_input_signals(list);
}

void
IIRScram_WaveformElement::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_value()->_build_sensitivity_list(sensitivity_list);
}

IIR_Boolean 
IIRScram_WaveformElement::_is_resolved(){
  IIR_Boolean retval = TRUE;

  if( get_value() != NULL && get_value()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

  if( get_time() != NULL && get_time()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}

IIR_Boolean
IIRScram_WaveformElement::_is_readable(){
  if( get_value() != NULL ){
    return get_value()->_is_readable();
  }
  else{
    return TRUE;
  }
}

IIR_Boolean
IIRScram_WaveformElement::_is_above_attribute_found() {
  ASSERT(get_value() != NULL);
  return get_value()->_is_above_attribute_found();
}

void
IIRScram_WaveformElement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  ASSERT(get_value() != NULL);
  get_value()->_build_above_attribute_set(to_build);
}

IIR*
IIRScram_WaveformElement::_clone() {
  IIR_WaveformElement *newwave;
  IIR *value, *time;

  newwave = new IIR_WaveformElement();
  IIR::_clone(newwave);

  value = get_value();
  if (value != NULL) {
    value = value->_clone();
  }
  newwave->set_value(value);

  time = get_time();
  if (time != NULL) {
    time = time->_clone();
  }
  newwave->set_time(time);

  return newwave;
}

visitor_return_type *
IIRScram_WaveformElement::_accept_visitor( node_visitor *visitor, visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_WaveformElement(this, arg);
}
