
#ifndef IIRSCRAM_WAIT_STATEMENT_HH
#define IIRSCRAM_WAIT_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Narayanan Thondugulam 

#include "IIRBase_WaitStatement.hh"

class IIR_DesignatorList;
class IIR_List;
class IIR_AboveAttribute;
template <class type> class set;

class IIRScram_WaitStatement : public IIRBase_WaitStatement {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _type_check();
  IIR *_resolve_signal_name(IIR*);
  IIR *_clone();

  // methods and data for c++ code generation
  void _publish_cc( published_file &_cc_out );
  void _publish_cc_wait_label( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out, IIR_Char* );
  void _publish_cc_proc_wait_data( published_file &_cc_out );
  void _publish_cc_wait_decl( published_file &_cc_out );
  void _build_wait_list(dl_list<IIRScram_WaitStatement>* );
  void _publish_cc_procedure_wait( published_file &_cc_out );
  IIR_Int32 wait_id;

  //methods needed for elaboration
  void _get_list_of_input_signals( set<IIR> *list );

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_WaitStatement() {}
  virtual ~IIRScram_WaitStatement() = 0;
    
private:
};
#endif
