
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
  
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram
//          Kathiresan Nellayappan
 
#include <stdlib.h>
#include "IIRScram_TerminalDeclaration.hh"
#include "IIR_Identifier.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "IIR_Attribute.hh"
#include "error_func.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_TerminalDeclaration::IIRScram_TerminalDeclaration() {}

IIRScram_TerminalDeclaration::~IIRScram_TerminalDeclaration() {}

void
IIRScram_TerminalDeclaration::_publish_vhdl_decl(ostream &_vhdl_out){
  _vhdl_out << " terminal ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_subtype()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ;\n";
}

IIRScram_Declaration::declaration_type 
IIRScram_TerminalDeclaration::_get_type(){
   return TERMINAL;
}

void
IIRScram_TerminalDeclaration::_publish_cc_lvalue(ostream &_cc_out){
  _get_declarator()->_publish_cc_lvalue(_cc_out);
}

void
IIRScram_TerminalDeclaration::_publish_cc_lvalue(published_file &_cc_out){
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );
  if( cgen_sym_tab_ptr != NULL ){
    if( !cgen_sym_tab_ptr->in_scope(this) ){
      cgen_sym_tab_ptr->add_declaration(this);
    }
  }
  _get_declarator()->_publish_cc_lvalue(_cc_out);
}

void
IIRScram_TerminalDeclaration::_publish_cc_decl(published_file &_cc_out) {
  SCRAM_CC_REF(_cc_out, "IIRScram_TerminalDeclaration::_publish_cc_decl(published_file &_cc_out)");
  _cc_out << "AMSType ";
  _get_declarator()->_publish_cc_lvalue(_cc_out);
  _cc_out << ";\n";
}

void
IIRScram_TerminalDeclaration::_type_check() {
  IIR_ObjectDeclaration::_type_check();
}

