
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_SimultaneousIfStatement.hh"
#include "IIRScram_SimultaneousElsif.hh"
#include "IIR_Label.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "IIR_ArchitectureStatement.hh"
#include "published_file.hh"
#include "StandardPackage.hh"
#include "set.hh"

IIRScram_SimultaneousElsif::~IIRScram_SimultaneousElsif() {}

void
IIRScram_SimultaneousElsif::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << " elsif ";
  get_condition()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " use\n";
  if(then_sequence_of_statements.num_elements() != 0) {
    then_sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_vhdl(_vhdl_out);
  }
}

void
IIRScram_SimultaneousElsif::_publish_cc(published_file & ){
  // Do nothing
}

void
IIRScram_SimultaneousElsif::_type_check( set<IIR_TypeDefinition> * ){ 
  set_condition(IIR_Statement::_type_check_and_resolve_boolean_condition(get_condition()));
  
  if (get_else_clause() != NULL) {
    set<IIR_TypeDefinition> *bool_rvals = 
      new set<IIR_TypeDefinition>((IIR_TypeDefinition *)StandardPackage::get_boolean_type());
    get_else_clause()->_type_check( bool_rvals );
    delete bool_rvals;
  }
}

void
IIRScram_SimultaneousElsif::
_publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::
                                       SimultaneousIfPublishingPart current_part, published_file &_cc_out) {
  
  IIR_ArchitectureStatement *current_stmt = NULL;
  
  IIR_Int32 temp = _unique_qtys.num_elements();
  IIR_Declaration *current_set_qty = NULL;
  
  _cc_out << "  equation = new condition(\"ams_condition_";
  _cc_out << this;
  _cc_out << "\", ams_condition_";
  _cc_out << this;
  _cc_out << ", ";
  _cc_out << _unique_qtys.num_elements();
  if (_unique_qtys.num_elements() > 0) {
    _cc_out << ", ";
  }
  for( current_set_qty = _unique_qtys.get_element();
       current_set_qty != NULL;
       current_set_qty = _unique_qtys.get_next_element() ) {
    if (temp > 0) {
      _cc_out << "&(";
      current_set_qty->_publish_cc_lvalue(_cc_out);
      _cc_out << ") ";
      if (temp > 1) {
        _cc_out << ", ";
      }
      temp--;
    }
  }
  
  _cc_out << " );" << NL();
  _cc_out << "  equation->setEnclosingBlock(this);" << NL();
  
  switch(current_part) {
  case IIRScram_ArchitectureStatement::None: {
    _cc_out << "  add(equation);" << NL() << NL() << "  ";
  }
    break;
  case IIRScram_ArchitectureStatement::IF_PART: {
    _cc_out << " add(equation, YES);" << NL() << NL() << "  ";
  }
  case IIRScram_ArchitectureStatement::ELSE_PART: {
    _cc_out << " add(equation, NO);" << NL() << NL() << "  ";
  }
    break;
  default: {
    cerr << "Wrong enumeration for publishing simultaneous "
         << "if/elsif statement!!" << endl;
    cerr << "Aborting VHDL-AMS to C++ code generation ..." << endl;
    abort();
  }
    break;
  }
  _cc_out << "nextCondition(equation);" << NL() << NL() << "  ";
  
  for( current_stmt = then_sequence_of_statements.first();
       current_stmt != NULL;
       current_stmt = then_sequence_of_statements.successor(current_stmt) ) {
    ( static_cast <IIR_SimultaneousStatement *>(current_stmt) )->
      _publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement:: IF_PART,_cc_out);
  }
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::ELSE_PART,_cc_out);
  }
}

void
IIRScram_SimultaneousElsif::_publish_cc_ams_function_prototype(published_file &_cc_out) {
  IIR_ArchitectureStatement *current_stmt = NULL;
  
  _cc_out << NL() << "int" << NL();
  _cc_out << "ams_condition_";
  _cc_out << this;
  _cc_out << "( component *, double * );" << NL();
  
  for( current_stmt = then_sequence_of_statements.first();
       current_stmt != NULL;
       current_stmt = then_sequence_of_statements.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement*>(current_stmt))->_publish_cc_ams_function_prototype(_cc_out);
  }
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_cc_ams_function_prototype(_cc_out);
  }
}

void
IIRScram_SimultaneousElsif::_publish_cc_ams_function_body(published_file &_cc_out) {
  IIR_ArchitectureStatement *current_stmt = NULL;
  IIR *condition = get_condition();
  PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(SIMULTANEOUS_IF);
  _stmt_qty_index = 0;
  _stmt_signal_index = 0;
  condition->_set_stmt_qty_index(&_stmt_qty_index, &_unique_qtys);
  condition->_set_stmt_signal_index(&_stmt_signal_index, &_unique_signals);
  condition->_build_generic_parameter_set(&_unique_generic_constants);

  _cc_out << NL() << "int" << NL();
  _cc_out << "ams_condition_";
  _cc_out << this;
  _cc_out << "( component *currentCondition, double *qty ) {" << NL();
  _cc_out << "  currentCondition = currentCondition;\n"
          << "  qty = qty;\n";
  _cc_out << "  return ( ( SAVANT_BOOLEAN_TRUE == ";
  condition->_publish_cc_ams_function(_cc_out);
  _cc_out << " ) ? 1 : 0 );" << NL();
  _cc_out << "}" << NL() << NL();
  condition->_flush_stmt_index();
  
  _set_currently_publishing_unit(_saved_publishing_unit);
  for( current_stmt = then_sequence_of_statements.first();
       current_stmt != NULL;
       current_stmt = then_sequence_of_statements.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement *> (current_stmt))->_publish_cc_ams_function_body(_cc_out);
  }
  if (get_else_clause() != NULL) {
    get_else_clause()->_publish_cc_ams_function_body(_cc_out);
  }
}
