
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_ReferenceAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "StandardPackage.hh"
#include "published_file.hh"
#include "IIR_TerminalDeclaration.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_NatureDefinition.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_BranchQuantityDeclaration.hh"
#include "set.hh"   
#include "symbol_table.hh"
#include "error_func.hh"
#include "sstream-wrap.hh"

extern symbol_table *cgen_sym_tab_ptr;
extern symbol_table *cgen_arch_sym_tab_ptr;

IIRScram_ReferenceAttribute::~IIRScram_ReferenceAttribute() {}
     
void
IIRScram_ReferenceAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'REFERENCE ";
}
      
IIR_TextLiteral *
IIRScram_ReferenceAttribute::_build_attribute_name() {
  char *name = "reference";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_ReferenceAttribute::get_subtype(){
  IIR *my_prefix = get_prefix();
  set<IIR_Declaration> *terminal_decl_set = my_prefix->_symbol_lookup();
  IIR_Declaration *term_decl = NULL;
  if (terminal_decl_set == NULL) {
    report_undefined_symbol(my_prefix);
    return NULL;
  }
  term_decl = terminal_decl_set->get_element();
  while (term_decl != NULL) {
    if (term_decl->_is_terminal() == FALSE) {
      terminal_decl_set->remove(term_decl);
    }
    term_decl = terminal_decl_set->get_next_element();
  }
  switch (terminal_decl_set->num_elements()) {
  case 0: {
    ostringstream cerr;
    cerr << "|" << _get_attribute_name() 
	 << "| may only be applied to terminals." << endl;
    return NULL;
  }
    break;
  case 1: {
    set_prefix(terminal_decl_set->get_element());
  }
    break;
  default: {
    report_ambiguous_error(my_prefix, terminal_decl_set);
    return NULL;
  }
  }
  ASSERT(get_prefix()->get_subtype() != NULL);
  return (get_prefix()->get_subtype())->get_across();
}

IIR_Declaration *
IIRScram_ReferenceAttribute::_get_implicit_declaration( const string &decl_name,
							IIR_TypeDefinition *decl_nature ){
  return (IIR_Declaration*)_build_free_quantity_declaration( decl_name, decl_nature );
}

void
IIRScram_ReferenceAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ReferenceAttribute::_publish_cc_lvalue" );
  _publish_cc_ams_function(_cc_out);
}

void
IIRScram_ReferenceAttribute::_publish_cc_ams_function(published_file &_cc_out) {
  ((IIR_Attribute*)this)->_get_implicit_declaration()->_publish_cc_ams_function(_cc_out);
}

void
IIRScram_ReferenceAttribute::_set_stmt_qty_index(IIR_Int32 *index, set<IIR_Declaration>
						 *quantity_set) {
  IIR_Declaration* my_decl = (IIR_Declaration*)get_prefix(); 
  set<IIR_Declaration> *nature_dec;
  nature_dec = my_decl->_symbol_lookup();
  if (nature_dec->get_element()->get_kind() == IIR_NATURE_DECLARATION) {    
    //DO NOTHING AT PRESENT
  }    
  else {
    if (cgen_sym_tab_ptr !=NULL) {
      if (!cgen_sym_tab_ptr->in_scope((IIR_Declaration*)get_prefix())) {
	cgen_sym_tab_ptr->add_declaration((IIR_Declaration*)get_prefix());
      }
    }
    if (cgen_arch_sym_tab_ptr !=NULL) {
      if (!cgen_arch_sym_tab_ptr->in_scope((IIR_Declaration*)get_prefix())) {
	cgen_arch_sym_tab_ptr->add_declaration((IIR_Declaration*)get_prefix());
      }
    }
  }
  ((IIR_Attribute*)this)->_get_implicit_declaration()-> _set_stmt_qty_index(index,quantity_set);
}

IIR_Boolean
IIRScram_ReferenceAttribute::_reference_quantity_found() {
  return TRUE;                                       
} 

void
IIRScram_ReferenceAttribute::_build_reference_quantity_list(dl_list<IIR_ReferenceAttribute> * reference_quantity_list) {
  reference_quantity_list->append((IIR_ReferenceAttribute*)this);
}
                                       
                                       

