
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Narayanan Thondugulam
//          Malolan Chetlur     
//          Radharamanan Radhakrishnan
//          Swaminathan Subramanian
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIRScram_PackageDeclaration.hh"
#include "IIR_ObjectDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_SequentialStatementList.hh"
#include "IIR_FileDeclaration.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"
#include "sstream-wrap.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_TerminalDeclaration.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "language_processing_control.hh"

extern symbol_table *cgen_sym_tab_ptr;
extern language_processing_control *lang_proc;

IIRScram_PackageDeclaration::IIRScram_PackageDeclaration() {
  cgen_sym_tab_ptr = NULL;
}

IIRScram_PackageDeclaration::~IIRScram_PackageDeclaration() {}

void 
IIRScram_PackageDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  PublishedUnit oldUnit;
  
  context_items._publish_vhdl(_vhdl_out);

  oldUnit = _get_currently_publishing_vhdl_unit();
  _set_currently_publishing_vhdl_unit(IIRScram::PACKAGE_PUB);
  
  _vhdl_out << "package ";
  _get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  package_declarative_part._publish_vhdl_decl(_vhdl_out);
  _vhdl_out << "end package;\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}

void 
IIRScram_PackageDeclaration::_publish_vhdl(ostream &_vhdl_out) {
  _get_declarator()->_publish_vhdl(_vhdl_out);
}  

void 
IIRScram_PackageDeclaration::_publish_cc_package_name( ostream &os ){
  os << *_get_declarator() << "Pkg";
}

void
IIRScram_PackageDeclaration::_publish_cc_binding_name(ostream &os) {
  if( !_is_standard() ){
    _publish_cc_package_name( os );
  }
}
    
void 
IIRScram_PackageDeclaration::_publish_cc(){
  const string _prev_publish_name = _get_current_publish_name(); // Save previous value.
  IIR *_prev_publish_node = _get_current_publish_node();
  ostringstream package_name;
  symbol_table cgen_sym_tab( 4093, false );

  _set_current_publish_node( this );

  _publish_cc_package_name( package_name );
  _set_current_package_name( package_name.str() );
  _set_current_publish_name( _get_current_package_name() );

  _set_currently_publishing_unit(IIRScram::PACKAGE_PUB);

  cgen_sym_tab_ptr = &cgen_sym_tab;

  _publish_cc_header();
  _publish_cc_cc_file();
  _set_currently_publishing_unit(NONE);

  cgen_sym_tab_ptr = NULL;
  _set_current_publish_name( _prev_publish_name );
  _set_current_publish_node( _prev_publish_node );

  _set_current_package_name( "" );
}

void 
IIRScram_PackageDeclaration::_publish_cc_header(){
  published_header_file header_file( _get_library_directory(),
				     _get_current_package_name(),
				     this );
  SCRAM_CC_REF( header_file, "IIRScram_PackageDeclaration::_publish_cc_header" );
  IIRScram::_publish_cc_include( header_file, "tyvis/STDTypes.hh" );
  if(lang_proc->processing_vhdl_ams()) {
    IIRScram::_publish_cc_include( header_file, "tyvis/AMSType.hh" );
  }
  context_items._publish_cc( header_file );
  _publish_cc_headers( header_file );
  // package_declarative_part._publish_cc_extern_type_info( header_file );
  package_declarative_part._publish_cc_package_declarations( header_file );
}

void 
IIRScram_PackageDeclaration::_publish_cc_headers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_PackageDeclaration::_publish_cc_headers" );

  IIRScram::_publish_cc_include( _cc_out, "tyvis/VHDLProcess.hh" );

  IIR_Declaration *decl = package_declarative_part.first();
  while (decl != NULL) {
    decl->_publish_cc_include( _cc_out );
    decl = package_declarative_part.successor(decl);
  }
}  

void
IIRScram_PackageDeclaration::_publish_cc_cc_file(){
  published_cc_file cc_file( _get_library_directory(),
			     _get_current_publish_name(),
			     this );

  SCRAM_CC_REF( cc_file, "IIRScram_PackageDeclaration::_publish_cc_cc_file" );

  IIRScram::_publish_cc_include( cc_file, "tyvis/SharedFileType.hh" );
  
  _publish_cc_include( cc_file );

  IIR_Declaration *decl = package_declarative_part.first();
  for(decl = package_declarative_part.first();decl != NULL; decl = package_declarative_part.successor(decl)) {
    switch(decl->get_kind()) {
    case IIR_CONSTANT_DECLARATION:
      ((IIR_ConstantDeclaration *) decl)->_publish_cc_init_package_constant( cc_file );
      break;
    case IIR_SIGNAL_DECLARATION:
      cc_file << decl->get_subtype()->_get_cc_type_name() << NL();
      decl->_publish_cc_elaborate( cc_file );
      cc_file << OS("(ObjectBase::SIGNAL_NETINFO");
      
      if ((decl->get_subtype()->_is_array_type() == TRUE) ||
	  (decl->get_subtype()->_is_record_type() == TRUE)) {
	decl->get_subtype()->_publish_cc_object_type_info( cc_file );
	cc_file << "," << NL();
	decl->get_subtype()->_publish_cc_resolution_function_id( cc_file );
      }
      
      if(decl->get_subtype()->_is_array_type() &&
         decl->get_subtype()->_is_anonymous() == TRUE) {
        cc_file << "," << NL();
        decl->get_subtype()->_publish_cc_range( cc_file );
      } 
      else if(decl->get_subtype()->_is_unconstrained_array_type()){
        ASSERT(decl->get_value() != NULL);
        if(decl->get_value()->get_kind() != IIR_CONCATENATION_OPERATOR){
          cc_file << "," << NL();
          decl->get_value()->_publish_cc_range( cc_file );
        }
      }
      cc_file << CS(");");
      break;
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      decl->_publish_cc_type_info( cc_file );
      break;
    case IIR_USE_CLAUSE:
      break;
    case IIR_PROCEDURE_DECLARATION:
    case IIR_FUNCTION_DECLARATION:
      decl->_publish_cc_decl( cc_file );
      break;
    case IIR_ATTRIBUTE_SPECIFICATION:
      ((IIR_AttributeSpecification *) decl)->_publish_cc_decl_with_constructor( cc_file );
      break;
    case IIR_COMPONENT_DECLARATION:
    case IIR_ATTRIBUTE_DECLARATION:
    case IIR_TERMINAL_DECLARATION:
      // Nothing to be done.
      break;
    case IIR_FILE_DECLARATION:
      ((IIR_FileDeclaration *) decl)->_publish_cc_shared_file_decl( cc_file );
      break;
    case IIR_NATURE_DECLARATION:
      if ( ((IIR_NatureDeclaration*)decl)->get_nature()->get_kind() != IIR_ARRAY_SUBNATURE_DEFINITION ){
	cc_file << "AMSType ";
	((IIR_NatureDeclaration*)decl)->_get_reference_terminal()->_publish_cc_lvalue(cc_file);
	cc_file << "(ObjectBase::TERMINAL , \"";
	((IIR_NatureDeclaration*)decl)->_get_reference_terminal()->_publish_cc_lvalue(cc_file);
	cc_file << "\");" << NL();
      }
      else {
	decl->_publish_cc_type_info( cc_file );
	cc_file << ";\n";
      }	
      break;  
    default:
      cerr << "Unimplemented declaration type: " << decl->get_kind_text()
	   << " in IIRScram_PackageDeclaration::_publish_cc_cc_file( published_file &cc_file )." 
	   << endl;
      abort();
      break;
    }
  }
}

void
IIRScram_PackageDeclaration::_publish_cc_include_decls_prefix( ostream &os ) {
  _publish_cc_package_name( os );
}

IIR_Declaration*
IIRScram_PackageDeclaration::_get_prefix_declaration() {
  return this;
}

IIR_Declaration*
IIRScram_PackageDeclaration::_get_package_declaration() {
  return this;
}

IIRScram_Declaration::declaration_type 
IIRScram_PackageDeclaration::_get_type(){
  return PACKAGE_DT;
}

set<IIR_Declaration> *
IIRScram_PackageDeclaration::_find_declarations( IIR_Name *to_find ){
  return package_declarative_part._find_declarations( to_find );
}

void 
IIRScram_PackageDeclaration::_add_to_declarative_region( set<IIR_Declaration> *set_to_add ){
  IIR_Declaration::_add_to_declarative_region( package_declarative_part, set_to_add );
}

void 
IIRScram_PackageDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  ASSERT( sym_tab != NULL );

  sym_tab->make_visible( this );
  context_items._make_visible_as_context_list( sym_tab );
  sym_tab->make_visible( &package_declarative_part );
}

void 
IIRScram_PackageDeclaration::_type_check( ){
  IIR_SequentialStatementList empty_list;

  package_declarative_part._type_check_attribute_specifications( empty_list );
  package_declarative_part._type_check_configuration_specifications( empty_list );
  package_declarative_part._type_check_disconnection_specifications(  );
}

visitor_return_type *IIRScram_PackageDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PackageDeclaration(this, arg);
};
