
#ifndef IIRSCRAM_LIST_HH
#define IIRSCRAM_LIST_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_List.hh"

class IIR_List;
class IIR_SimpleName;

class IIRScram_List : public IIRBase_List {

public:
  void _publish_vhdl_decl( ostream &os ){
    _publish_vhdl_decl( os, NULL );
  }
  void _publish_vhdl_decl(ostream &, char *separator );

  void _publish_vhdl(ostream &, char *separator = "\n" );

  void _publish_cc_headers( published_file &_cc_out );

  static void _listcopy( IIR_List &dest, IIR_List &source );
  ostream &_print( ostream &os );

  IIR_Boolean _is_resolved();
  
  IIR_Boolean _is_iir_list(){ return TRUE; }

  virtual IIR *_clone(  );
  virtual void _clone( IIR * );

  virtual IIR_Label *_find_instantiate_label( IIR_SimpleName * );
  
  // Append all elements in this non-NULL list.
  virtual void _append( IIR_List * );
  
  void _make_interface_visible( symbol_table * );

  // This is a dangerous method - it calls delete on every member of this
  // list!  Make sure you know that it's safe to delete the elements in the
  // list before you call it!
  void _destroy_list();

protected:
  
  IIRScram_List() {};
  virtual ~IIRScram_List() = 0;
    
private:
  

};

#endif
