// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include <clutils/FileManager.h>
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "IIRScram_LibraryDeclaration.hh"
#include "IIR_Name.hh"
#include "IIR_Identifier.hh"
#include "IIR_LibraryUnitList.hh"
#include "IIR_LibraryUnit.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_PackageDeclaration.hh"
#include "IIR_ConfigurationDeclaration.hh"
#include "StandardPackage.hh"
#include "sstream-wrap.hh"


class IIR_DeclarationList;
extern char *design_library_name;


IIRScram_LibraryDeclaration::~IIRScram_LibraryDeclaration() {}


IIRScram_Declaration::declaration_type 
IIRScram_LibraryDeclaration::_get_type(){
   return LIBRARY;
}

set<IIR_Declaration> *
IIRScram_LibraryDeclaration::_find_declarations( IIR_Name *to_find ){
  set<IIR_Declaration> *retval = new set<IIR_Declaration>;

  IIR_EntityDeclaration *entity_decl = NULL;
  IIR_PackageDeclaration *package_decl = NULL; 
  IIR_ConfigurationDeclaration *configuration_decl;  
  
  set<IIR_Declaration> *unit_decls = primary_units._find_declarations( to_find );
  if( unit_decls != NULL ){
    retval->add( unit_decls );
  }
  delete unit_decls;

  entity_decl = library_manager::instance()->lookup_entity( FALSE,
							    to_find,
							    (IIR_LibraryDeclaration *)this );
  
  if( entity_decl != NULL ){
    retval->add( entity_decl );
  }

  package_decl = library_manager::instance()->lookup_package( FALSE,
							      to_find,
							      (IIR_LibraryDeclaration *)this );
  if( package_decl != NULL ){
    retval->add( package_decl );
  }
  
  configuration_decl = library_manager::instance()->lookup_configuration( FALSE, 
									  to_find, 
									  (IIR_LibraryDeclaration *)this );
  if( configuration_decl != NULL ){
    retval->add( configuration_decl );
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }

  return retval;
}

void 
IIRScram_LibraryDeclaration::_add_to_declarative_region( set<IIR_Declaration> *set_to_add ){
  IIR_Declaration::_add_to_declarative_region( primary_units, set_to_add );
}

void 
IIRScram_LibraryDeclaration::_publish_cc_include_path( ostream &os ){
  os << _get_path_to_directory();
}

void 
IIRScram_LibraryDeclaration::_publish_cc_library_file_name( ostream &os ){
  // We don't need to generate anything for the standard declaration.
  // Also, we don't want to generate anything if we're emitting the
  // Makefile for this library - i.e. we can't link _this_ library's .a
  // file since it doesn't exist until after this method runs.
  bool need_to_generate = true;
  if( (IIR_LibraryDeclaration*)this == StandardPackage::get_std_decl() ){
    need_to_generate = false;
  }
  
  if( need_to_generate == true ){
    os << _get_path_to_directory() << FileManager::instance()->getDirectorySeparator()
       << *get_declarator();
    os << library_manager::get_library_suffix() << ".la";
  }
}


void 
IIRScram_LibraryDeclaration::_publish_vhdl_decl( ostream &os ){
  os << "library ";
  _publish_vhdl( os );
}

void 
IIRScram_LibraryDeclaration::_set_path_to_directory( const string new_path ){ 
  path_to_directory = FileManager::instance()->getRealPath( new_path );
}

void
IIRScram_LibraryDeclaration::_mangle_declarator(){
  ostringstream mangledDeclarator;
  mangledDeclarator << *get_declarator();
  _set_mangled_declarator(mangledDeclarator.str());
}

visitor_return_type *
IIRScram_LibraryDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LibraryDeclaration(this, arg);
};
