
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_LibraryClause.hh"
#include "IIR_Identifier.hh"
#include "IIR_DesignFile.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_SimpleName.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "error_func.hh"
#include "sstream-wrap.hh"


IIRScram_LibraryClause::~IIRScram_LibraryClause(){}

void 
IIRScram_LibraryClause::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "library ";
  get_logical_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_LibraryClause::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "library ";
  get_logical_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_LibraryClause::_type_check(){
  IIR_Boolean is_std_lib = FALSE;
  IIR *logical_name = get_logical_name();
  ASSERT( logical_name->_is_text_literal() == TRUE );

  IIR_TextLiteral *as_literal = (IIR_TextLiteral *)logical_name;
  
  if( IIR_TextLiteral::_cmp( as_literal, "std" ) == 0 ){  
    is_std_lib = TRUE;
  }

  // Calling this method in this manner will cause the library to be found
  // and be added to the symbol table if needed.  
  IIR_LibraryDeclaration *lib_decl = library_manager::instance()->find_library( as_literal );
  if( lib_decl == NULL ){
    ostringstream err;
    err << "Could not locate a library directory corresponding to logical library name |" 
	<< *logical_name << "|.  Perhaps you need to create it with the option "
	<< "--design-library-name, or add a directory to the environment variable "
	<< "VHDL_LIBRARY_PATH";
    report_error( logical_name, err.str() );
  }
  else{
    if( is_std_lib == FALSE ){
      copy_location( this, lib_decl );
      lib_decl->_add_declaration();    
    }
  }

  _set_library_declaration( lib_decl );  
}






visitor_return_type *IIRScram_LibraryClause::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LibraryClause(this, arg);
};
