
#ifndef IIRSCRAM_INTEGER_LITERAL_HH
#define IIRSCRAM_INTEGER_LITERAL_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Radharamanan Radhakrishnan

#include "IIRBase_IntegerLiteral.hh"

template <class type> class set;
class IIR_Declaration;

class IIRScram_IntegerLiteral : public IIRBase_IntegerLiteral {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_range(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_rvalue( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_value( published_file &_cc_out );
  void _publish_cc_universal_value( published_file &_cc_out );
  void _publish_cc_initialization_value( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_condition( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_type_name( ostream &os );
  void _publish_cc_ams_function( published_file &_cc_out );

  const string _get_cc_type_name();

  /** Overloaded to cause a runtime error if a non-integer type is set on
      an integer literal.  */
  void _set_subtype( IIR_TypeDefinition * );

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0); 
  void _type_check(set<IIR_TypeDefinition>*) {}
  ostream &_print( ostream & );
  const string print(IIR_Int32);
  IIR_Int32 _get_value();
  IIR_Boolean _is_integer_literal();
  IIR_Boolean _is_negative();
  IIR *_clone() { return this; }

  IIR_IntegerLiteral *_get_integer_static_value();

protected:
  IIRScram_IntegerLiteral() {}
  virtual ~IIRScram_IntegerLiteral() = 0;
    
private:
};
#endif
