#ifndef IIRSCRAM_FILE_DECLARATION_HH
#define IIRSCRAM_FILE_DECLARATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_FileDeclaration.hh"

class IIR_List;
class IIR_FileDeclaration;

class IIRScram_FileDeclaration : public IIRBase_FileDeclaration {



public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_decl( published_file &_cc_out );
  void _publish_cc_shared_file_decl( published_file &_cc_out );
  
  IIR_Boolean _is_read_file();
  IIR_Boolean _is_write_file();
  IIR_Boolean _is_shared_file();
  
  declaration_type _get_type();

  IIR *_clone();

  /** For some reason, sometimes the code generate wants a fresh clone
     generated.  */
  void _clear_clone(){ _my_clone = 0; }

  IIR_Boolean _is_file(){ return TRUE; }

  void _publish_cc_include( published_file & ){}

protected:
  IIRScram_FileDeclaration() { _my_clone = NULL; }
  virtual ~IIRScram_FileDeclaration() = 0;

private:
  IIR_FileDeclaration *_my_clone;
};
#endif

