// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_DrivingAttribute.hh"
#include "IIR_Identifier.hh"
#include "symbol_table.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_DrivingAttribute::~IIRScram_DrivingAttribute() {}

void 
IIRScram_DrivingAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'DRIVING ";
}


void 
IIRScram_DrivingAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  ASSERT(IIR_Attribute::_get_implicit_declaration() != NULL);
  ASSERT(IIR_Attribute::_get_implicit_declaration()->_is_resolved() == TRUE);

  if (!cgen_sym_tab_ptr->in_scope(IIR_Attribute::_get_implicit_declaration())) {
    cgen_sym_tab_ptr->add_declaration(IIR_Attribute::_get_implicit_declaration());
  }

  _cc_out << "driving( ";
  get_prefix()->_publish_cc_lvalue( _cc_out );
  _cc_out << " )";
}


IIR_TextLiteral *
IIRScram_DrivingAttribute::_build_attribute_name() {
  char *name = "driving";
  return IIR_Identifier::get( name, strlen(name) );
}


//void 
//IIRScram::_record() {}
//IIR * 
//IIRScram_DrivingAttribute::_transmute() {}

visitor_return_type *IIRScram_DrivingAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_DrivingAttribute(this, arg);
};
