
#ifndef IIRSCRAM_CONSTANT_DECLARATION_HH
#define IIRSCRAM_CONSTANT_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam 

#include "IIRBase_ConstantDeclaration.hh"

class IIRScram_ConstantDeclaration : public IIRBase_ConstantDeclaration {
public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl( ostream & );
  void _publish_vhdl_range( ostream & );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_init( published_file &_cc_out );
  void _publish_cc_constant_object_init( published_file &_cc_out );
  void _publish_cc_scalar_init( published_file &_cc_out );
  void _publish_cc_composite_init( published_file &_cc_out );
  void _publish_cc_access_init( published_file &_cc_out );
  void _publish_cc_file_init( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );
  void _publish_cc_universal_value( published_file &_cc_out );
  void _publish_cc_value( published_file &_cc_out );
  void _publish_cc_left( published_file &_cc_out );
  void _publish_cc_right( published_file &_cc_out );
  void _publish_cc_universal_left( published_file &_cc_out );
  void _publish_cc_universal_right( published_file &_cc_out );
  void _publish_cc_init_package_constant( published_file &_cc_out );
  const string _get_cc_object_type();
  void _publish_cc_initialization_value( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_decl_with_constructor_args( published_file &_cc_out );
  void _publish_cc_ams_function(published_file &);

  void _set_scoping_prefix();
  
  IIR_Boolean _is_constant(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  IIR_Boolean _is_static_expression();

  IIR_Boolean _is_ascending_range();
  IIR_Boolean _is_implicit_declaration();
  
  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_globally_static_primary();

  declaration_type _get_type();
  
  IIR *_clone();
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);

protected:
  IIRScram_ConstantDeclaration() {};
  virtual ~IIRScram_ConstantDeclaration() = 0;
    
private:
};
#endif



