#ifndef IIRSCRAM_ATTRIBUTE_SPECIFICATION_HH
#define IIRSCRAM_ATTRIBUTE_SPECIFICATION_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_AttributeSpecification.hh"

class IIRScram_AttributeSpecification : public IIRBase_AttributeSpecification {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);

  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_decl( published_file &_cc_out );
  void _publish_cc_decl_with_constructor( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );

  void _type_check( IIR_DeclarationList &declarative_region );

  IIR_Boolean _is_specification(){ return TRUE; }
  IIR_Boolean _can_be_in_same_region( IIR_Declaration * );

  /**
     Returns the value of the specification as a string.
  */
  const string _get_cc_value_string();

  /** This holds the the declaration of the attribute that is being
      specified... */
  void _set_declaration( IIR_Declaration *);
  IIR_Declaration *_get_declaration();

  IIR_TypeDefinition *get_subtype();
  declaration_type _get_type();

  void _set_entity_constraint( IIR_Boolean (IIR_Declaration::*constraining_function )() ){
    _my_constraining_function = constraining_function;
  }

  IIR_Boolean (IIR_Declaration::*_get_entity_constraint() )() {
    return _my_constraining_function;
  }

  IIR_Boolean _is_iir_attribute_specification(){ return TRUE; }
  
  IIR_Boolean _is_foreign_attribute_specification( );

  void _publish_cc_include( published_file & ){}

protected:
  IIRScram_AttributeSpecification(){ 
    _my_constraining_function = 0; 
    attribute_declaration = NULL;
  }

  virtual ~IIRScram_AttributeSpecification() = 0;
    
private:
  IIR_Declaration *attribute_declaration;
  void _publish_cc_decl_constructor_args( published_file &_cc_out );
  IIR_Boolean (IIR_Declaration::*_my_constraining_function )();
};
#endif
