
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur
//          Timothy J. McBrayer
//          Krishnan Subramani
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_IntegerLiteral.hh"
#include "IIR_FunctionDeclaration.hh"
#include "published_file.hh"
#include "IIR_ScalarNatureDefinition.hh"

IIRScram_ArraySubtypeDefinition::~IIRScram_ArraySubtypeDefinition() {}

void
IIRScram_ArraySubtypeDefinition::_publish_vhdl( ostream &_vhdl_out ){
  if( _get_declaration() != NULL ){
    _get_declaration()->_publish_vhdl(_vhdl_out);
  } 
  else {
    ASSERT( get_base_type() != NULL );
    get_base_type()->_publish_vhdl(_vhdl_out);
    if (_get_index_subtype() != NULL) {
      _vhdl_out << "(";
      _get_index_subtype()->_publish_vhdl_range(_vhdl_out);
      _vhdl_out << ")";
    }
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_vhdl_type_decl( ostream &_vhdl_out ){
  IIR_TypeDefinition *node ;
  int index, max_index ;
  
  ASSERT(_get_index_subtype() != NULL );
  ASSERT(get_element_subtype() != NULL );
  
  if ( get_resolution_function() != NULL )  {
    get_resolution_function()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
  }
  
  _vhdl_out << "array ";
  ASSERT ( get_base_type()->_get_index_subtype() != NULL );
  
  if(( get_base_type()->_is_unconstrained_array_type() == TRUE) ||
      (get_base_type()->_get_index_subtype()->_is_enumeration_type() == TRUE) ){
    
    _vhdl_out << " ( ";
    
    index = 1 ;
    max_index = _get_num_indexes();
    for (node = this; (index <= max_index); index++, node = node->_get_element_subtype())  {
      ASSERT(node->_is_array_type() == TRUE );
      ASSERT(node->_get_index_subtype() != NULL );
      ASSERT(node->_get_element_subtype() != NULL );
      
      // The next assertion is invalid - what about
      // subtype foo1 is memory (1 to 10);
      //    ASSERT(node->_get_index_subtype()->_get_type_mark() != NULL);

      if (index > 1) { _vhdl_out << ", "; }
      node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    }
    
    _vhdl_out << " ) ";
    
  }
  _vhdl_out << " of ";
  _get_final_subtype()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_ArraySubtypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_TypeDefinition *node ;
  int index, max_index ;
  
  ASSERT(_get_index_subtype() != NULL );
  ASSERT(get_element_subtype() != NULL );
  
  if ( get_resolution_function() != NULL )  {
    get_resolution_function()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
  }
  
  get_base_type()->_publish_vhdl(_vhdl_out);
  ASSERT ( get_base_type()->_get_index_subtype() != NULL );
  
  if( ( get_base_type()->_is_unconstrained_array_type() == TRUE &&
	_is_unconstrained_array_type() == FALSE ) 
      ||
      get_base_type()->_get_index_subtype()->_is_enumeration_type() == TRUE ){
    
    _vhdl_out << " ( ";
    
    index = 1 ;
    max_index = _get_num_indexes();
    for (node = this; (index <= max_index); index++, node = node->_get_element_subtype())  {
      ASSERT(node->_is_array_type() == TRUE );
      ASSERT(node->_get_index_subtype() != NULL );
      ASSERT(node->_get_element_subtype() != NULL );
      
      // The next assertion is invalid - what about
      // subtype foo1 is memory (1 to 10);
      //    ASSERT(node->_get_index_subtype()->_get_type_mark() != NULL);

      if (index > 1) {
	_vhdl_out << ", ";
      }
      
      node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    }
    
    _vhdl_out << " ) ";
    
    if ( get_base_type()->_is_anonymous() == TRUE )  {
      _vhdl_out << " of ";
      node->_publish_vhdl(_vhdl_out);
    }
  }
}

void
IIRScram_ArraySubtypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  _publish_vhdl_decl(_vhdl_out);
}

IIR_ScalarTypeDefinition *
IIRScram_ArraySubtypeDefinition::_get_index_subtype(){
  if(get_index_subtype() != NULL) {
    return get_index_subtype();
  } else {
    ASSERT(get_base_type() != NULL);
    return get_base_type()->_get_index_subtype();
  }
}

IIR_Boolean
IIRScram_ArraySubtypeDefinition::_is_subtype() {
  return TRUE;
}

ostream&
IIRScram_ArraySubtypeDefinition::_print(ostream &os) {
  if( get_base_type()->_get_declaration() != NULL ){
    os << *((IIR_TypeDeclaration *) get_base_type()->_get_declaration())->get_declarator();
  }
  else{
    os << "ANONYMOUS";
  }
  return os;
}

void 
IIRScram_ArraySubtypeDefinition::_type_check(){
  if( get_resolution_function() != NULL ){
    get_resolution_function()->_type_check_resolution_function( this );
  }
  IIR_ArrayTypeDefinition::_type_check();
}

IIR *
IIRScram_ArraySubtypeDefinition::_clone(){
  IIR_ArraySubtypeDefinition *my_clone = new IIR_ArraySubtypeDefinition();
  IIRScram::_clone( my_clone );

  my_clone->set_resolution_function( get_resolution_function() );

  IIR_ArrayTypeDefinition::_clone( my_clone );

  return my_clone;
}

IIR_Boolean 
IIRScram_ArraySubtypeDefinition::_is_locally_static(){
  IIR_Boolean retval = TRUE;

  if( _is_unconstrained_array_type() == TRUE ){
    retval = FALSE;
  }
  else{
    IIR_ScalarTypeDefinition *current_index = get_index_subtype();
    if( current_index->_is_locally_static() == FALSE ){
      retval = FALSE;
    }
    IIR_TypeDefinition *current_element_type = get_element_subtype();
    ASSERT( current_element_type != NULL );
    while( current_element_type->_is_iir_array_type_definition() == TRUE && 
	   current_element_type->_is_element() == FALSE ){
      IIR_ArrayTypeDefinition *as_array_type = (IIR_ArrayTypeDefinition *)current_element_type;
      ASSERT( as_array_type->get_index_subtype() != NULL );
      if( as_array_type->get_index_subtype()->_is_locally_static() == FALSE ){
	retval = FALSE;
	break;
      }
      current_element_type = as_array_type->get_element_subtype();
      ASSERT( current_element_type != NULL );
    }
  }

  return retval;
}


IIR_Boolean 
IIRScram_ArraySubtypeDefinition::_is_globally_static(){
  IIR_Boolean retval = TRUE;

  if( _is_unconstrained_array_type() == TRUE ){
    retval = FALSE;
  }
  else{
    IIR_ScalarTypeDefinition *current_index = get_index_subtype();
    if( current_index->_is_globally_static() == FALSE ){
      retval = FALSE;
    }
    IIR_TypeDefinition *current_element_type = get_element_subtype();
    ASSERT( current_element_type != NULL );
    while( current_element_type->_is_iir_array_type_definition() == TRUE && 
	   current_element_type->_is_element() == FALSE ){
      IIR_ArrayTypeDefinition *as_array_type = (IIR_ArrayTypeDefinition *)current_element_type;
      ASSERT( as_array_type->get_index_subtype() != NULL );
      if( as_array_type->get_index_subtype()->_is_globally_static() == FALSE ){
	retval = FALSE;
	break;
      }
      current_element_type = as_array_type->get_element_subtype();
      ASSERT( current_element_type != NULL );
    }
  }

  return retval;
}

visitor_return_type *
IIRScram_ArraySubtypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ArraySubtypeDefinition(this, arg);
};
