
#ifndef IIRSCRAM_ARCHITECTURE_STATEMENT_HH
#define IIRSCRAM_ARCHITECTURE_STATEMENT_HH

// Copyright (c) 2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org

//---------------------------------------------------------------------------

#include "IIRBase_ArchitectureStatement.hh"
#include "IIR_AssociationList.hh"
#include <string>

class IIR_SignalDeclaration;

class IIRScram_ArchitectureStatement : public IIRBase_ArchitectureStatement {

public:
  IIR_Char* enclosing_path;

  IIR  *_transmute();

  void _publish_cc( published_file &_cc_out );
  void _publish_cc_scoping_prefix( ostream &_cc_out, IIR *, IIR * );
  void _publish_cc_state( published_file &_cc_out );
  virtual void _publish_cc_binding_name( ostream &outstream );
  virtual void _publish_cc_concurrent_stmt_init( published_file &_cc_out, IIR_DeclarationList* );

  /**
     Implements the publication of the call to the instantiate method for a
     concurrent statement to the published file @_cc_out. The instantiate
     method will instantiate a concurrent statement into the actual
     hierarchial description at the time of static elaboration prior to the
     dynamic elaboration of the simulation. This is where a concurrent
     statement may do its appropiate preparations.

     /param _cc_out The stream to publish the call to.
  */
  virtual void _publish_cc_instantiate_call( published_file &_cc_out );
  
  /**
     Publish the connect calls that are used at elaborate time.
  */
  virtual void _publish_cc_connect_call( published_file & ){}

  virtual void _publish_createNetInfo( published_file &_cc_out );
  virtual IIR_Boolean _publish_cc_type_info( published_file &_cc_out, IIR_Boolean = FALSE );
  virtual void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_headerfiles_for_cc_generate_statement( published_file &_cc_out );

  /**
     Implements _publish_cc_class for the two types of generate statements.
   */
  void _publish_cc_class_generate_stmt( published_file &_cc_out );

#ifdef PROCESS_GRAPH
  virtual void _publish_cc_driver_info( published_file &_cc_out );
#endif

  virtual IIR* get_instantiated_unit() {
    _report_undefined_scram_fn("get_instantiated_unit()");
    return NULL;
  };

  virtual IIR_AssociationList *_get_generic_map_aspect() {
    _report_undefined_scram_fn("_get_generic_map_aspect()");
    return NULL;
  }
  
  IIR_Boolean _is_iir_concurrent_statement() { return TRUE; }

  void _set_enclosing_scope(IIR *);
  IIR* _get_enclosing_scope();
  
  // This method is overriden by classes that can contain instantiate
  // statements.
  virtual void _type_check_instantiate_statements(){ }

  // This method should be overloaded by statements that contain concurrent
  // statement lists.  Currently it's overloaded for concurrent generate for
  // and concurrent generate if statements only.
  IIR_ArchitectureStatementList *_get_architecture_statment_list(){ return NULL; }

  enum SimultaneousIfPublishingPart {IF_PART, ELSE_PART, None};
  virtual void _publish_cc_characteristic_expressions(SimultaneousIfPublishingPart, published_file &);
  
protected:
  IIR* enclosingRegion;

  IIRScram_ArchitectureStatement();
  virtual ~IIRScram_ArchitectureStatement() = 0;
  
  string _get_enclosing_stmt_to_architecture_path();
  void _publish_cc_enclosing_stmt_to_architecture_path( ostream& outstream );
  
  virtual void _set_guard_signal( IIR_SignalDeclaration * );
  virtual void _resolve_guard_signal( symbol_table * );

private:

};
#endif
