
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     

//---------------------------------------------------------------------------

#include "IIR_AndOperator.hh"
#include "IIR_TypeDefinition.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_AndOperator::~IIRScram_AndOperator() {}

void 
IIRScram_AndOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " and ";
}

const string &
IIRScram_AndOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlAnd";
  return operator_name;
}

void
IIRScram_AndOperator::_publish_cc_xvalue( published_file &_cc_out,
					 void (IIR::*_publish_function)( published_file & )) {
  if( get_subtype()->_is_bit_type() ||
      get_subtype()->_is_boolean_type() ){
    _publish_cc_short_circuit_positive( _cc_out, _publish_function );
  }
  else{
    IIR_DyadicOperator::_publish_cc_xvalue( _cc_out, _publish_function );
  }
}

IIR*
IIRScram_AndOperator::_clone() {
  IIR_AndOperator *clone = new IIR_AndOperator();
  IIR_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_AndOperator::_get_operator_precedence(){
  return IIRScram::LOGICAL_OPERATOR ;
}

bool
IIRScram_AndOperator::_is_associative(IIR_Kind oper_kind){
  switch(oper_kind) {                                                        
  case IIR_OR_OPERATOR:
  case IIR_NAND_OPERATOR:
  case IIR_NOR_OPERATOR:
  case IIR_XOR_OPERATOR:
  case IIR_XNOR_OPERATOR:
    return FALSE;                                                             
  default:
    return TRUE;                                                             
  }                               
}

IIR_Boolean
IIRScram_AndOperator::_is_logical_operator(){
  return TRUE;
}

visitor_return_type *
IIRScram_AndOperator::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AndOperator(this, arg);
};

void
IIRScram_AndOperator::_publish_cc_ams_operator_name(published_file &_cc_out) {
  _cc_out << " && ";
} 
