
#ifndef IIRBASE_ACCESS_TYPE_DEFINITION_HH
#define IIRBASE_ACCESS_TYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIR_TypeDefinition.hh"

class IIR_TypeDefinition;
class IIR_AccessTypeDefinition;

class IIRBase_AccessTypeDefinition : public IIR_TypeDefinition {

public:
  IIR_Kind get_kind() const {return IIR_ACCESS_TYPE_DEFINITION;}
  IIR_Char *get_kind_text() const {return "IIR_AccessTypeDefinition";}

  static IIR_AccessTypeDefinition *get( IIR_TypeDefinition *designated_type );

  void set_designated_type( IIR_TypeDefinition *designated_type);

  IIR_TypeDefinition *get_designated_type();

protected:
  IIRBase_AccessTypeDefinition();
  virtual ~IIRBase_AccessTypeDefinition() = 0;
    
private:
  IIR_TypeDefinition *access_for_type;
};
#endif
