/* unxfile.h
 */

#ifndef XFILE_H
#define XFILE_H

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#define USE_GIO 1
#ifdef USE_GIO

#include <gio.h>
typedef GFile	*File;
#define Open(n, m)		gopen(n, m)
#define Read(f, b, s, n)	gread(f, b, s, n)
#define Write(f, b, s, n)	gwrite(f, b, s, n)
#define Flush(f)		gflush(f)
#define Seek(f, o, n)		(gseek(f, o, n), gtell(f))
#define Tell(f)			gtell(f)
#define Close(fd)		gclose(fd)

#else

typedef FILE	*File;
#define Open(n, m)		fopen(n, m)
#define Write(f, b, s, n)	fwrite(b, s, n, f)
#define Read(f, b, s, n)	fread(b, s, n, f)
#define Flush(f)		fflush(f)
#define Seek(f, o, n)		(fseek(f, o, n), ftell(f))
#define Tell(f)			ftell(f)
#define OpenFd(fd, mode)	fdopen(fd, mode)
#define Close(fd)		fclose(fd)
#define GetC(f)			getc(f)
#define PutC(f, c)		putc(c, f)
#define UnGetC(f, c)		ungetc(c, f)
#define ReadLine(f, buffer, n)	( (fgets(buffer, n, f) == NULL)	\
					? ( feof(f) ? 0 : -1 )	\
					: strlen(buffer) )

#define FileFd(fd)		fileno(fd)
#define SetBuffer(f, t, b, s)	setvbuf(f, b, t, s)

#endif

#ifdef RTMX
#define FileLeft(f)		(f->_r > 0)
#else
#define FileLeft(f)		(f->_cnt)
#endif


#define XFREAD	1
#define XFWRITE	2
#define XFCREAT	4

#define FileLineBuffer	_IOFBF
#define FileFullBuffer	_IOLBF
#define FileNullBuffer	_IONBF

#define Stdin	stdin
#define Stdout	stdout
#define Stderr	stderr

#define  Print	 printf
#define FPrint	fprintf
#define FPuts(file, string)	fputs(string, file)

typedef struct timeval Timeval;

/* Multiplex IO query structure
**/

typedef struct _Polls {
    File            f;
    int             qmode;
    int             rmode;
}               Polls;

typedef struct stat FileInfo;

#define Stat(file, info)		 stat(file, info)
#define FileStat(f, info)		fstat(FileFd(f), info)
#define FileInfoSize(info)	info.st_size
#define FileInfoMode(info)	info.st_mode
#define FileInfoUser(info)	info.st_uid
#define FileInfoGrop(info)	info.st_gid

#define PERM_READ	4
#define PERM_WRIT	2
#define PERM_EXEC	1

File XFile();

#ifdef __STDC__
File Accept(File file, char *mode, char **name);
File SokOpen(char *name, int port, int mode);
char *FindFile(char *, char *, char *, char *, struct stat *);
#else
File Accept();
File SokOpen();
char *FindFile();
#endif

#define getdtablesize()	16

void *MemSegment();

#define SigAction(sig, func, mask, flag)        {                       \
                struct  sigaction sigact;                               \
                sigact.sa_handler = func;                               \
                sigact.sa_flags   = flag;                               \
                memcpy(&sigact.sa_mask, mask, sizeof(sigset_t));        \
                                                                        \
        sigaction(sig, &sigact, NULL);          }

#endif
