#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CompassDialog {frame id} {
    global menu
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuCompassDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordCompassCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyCompassDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseCompassDialog $frame $id"

    # Init compass variables

    set arrows [$frame get marker $id compass arrow]
    set marker($frame,$id,narrow) [lindex $arrows 0]
    set marker($frame,$id,earrow) [lindex $arrows 1]
    EditCompassCB $frame $id

    # compass specific callbacks

    $frame marker $id callback edit EditCompassCB $frame
    $frame marker $id callback delete DeleteCompassDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "CloseCompassDialog $frame $id"

    # Labels

    label $w.ref.f.ntitle -text "North"
    entry $w.ref.f.north -textvariable marker($frame,$id,north) -width 13
    checkbutton $w.ref.f.narrow -variable marker($frame,$id,narrow) \
	-text "Arrow" -command "ArrowCompassDialog $frame $id"
    label $w.ref.f.etitle -text "East"
    entry $w.ref.f.east -textvariable marker($frame,$id,east) -width 13
    checkbutton $w.ref.f.earrow -variable marker($frame,$id,earrow) \
	-text "Arrow" -command "ArrowCompassDialog $frame $id"

    grid $w.ref.f.ntitle $w.ref.f.north $w.ref.f.narrow -padx 4 -sticky w
    grid $w.ref.f.etitle $w.ref.f.east $w.ref.f.earrow -padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyCompassDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseCompassDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyCompassDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuCompassDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
}

proc ApplyCompassDialog {frame id} {
    EditCompassDialog $frame $id
    ApplyMarkerDialog $frame $id
}

proc CloseCompassDialog {frame id} {
    $frame marker $id delete callback delete DeleteCompassDialog
    DeleteMarkerCBs $frame $id

    DeleteCompassDialog $frame $id
}

proc DeleteCompassDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,narrow)
    unset marker($frame,$id,earrow)
    unset marker($frame,$id,north)
    unset marker($frame,$id,east)
}

proc EditCompassDialog {frame id} {
    global marker

    $frame marker $id compass label \
	"\{$marker($frame,$id,north)\}" "\{$marker($frame,$id,east)\}"
}

proc EditCompassCB {frame id} {
    global marker

    set labels [$frame get marker $id compass label]
    set marker($frame,$id,north) [lindex $labels 0]
    set marker($frame,$id,east) [lindex $labels 1]
}

proc CoordCompassCB {frame id} {
    global marker

    CoordMarkerCB $frame $id
    $frame marker $id compass system \
	$marker($frame,$id,system) $marker($frame,$id,sky)
    MoveMarkerCB $frame $id
}

proc ArrowCompassDialog {frame id} {
    global marker
    
    $frame marker $id compass arrow \
	$marker($frame,$id,narrow) $marker($frame,$id,earrow)
}


