/*
 *
 *    enums.c -
 *
 *    Copyright (C) Ryuichi Tamura (tam@acc.ne.jp)
 *
 *    $Revision: 1.10 $
 *    $Date: 2001/07/22 08:16:43 $
 */

#include "magick.h"


VALUE mClassType;
VALUE mColorspaceType;
VALUE mCompositeOp;
VALUE mCompressionType;
VALUE mDecorationType;
VALUE mFilterTypes;
VALUE mGravityType;
VALUE mInterlaceType;
VALUE mNoiseType;
VALUE mPaintMethod;
VALUE mPreviewType;
/* VALUE mQuantumType; */
VALUE mRenderingIntent;
VALUE mResolutionType;

void Init_enums(void)
{
    mClassType = rb_define_module_under(mMagick, "ClassType");

    rb_define_const(mClassType, "Undefined", INT2FIX(UndefinedClass));
    rb_define_const(mClassType, "Direct", INT2FIX(DirectClass));
    rb_define_const(mClassType, "Pseudo", INT2FIX(PseudoClass));

    mColorspaceType = rb_define_module_under(mMagick, "ColorspaceType");

    rb_define_const(mColorspaceType, "Undefined", INT2FIX(UndefinedColorspace));
    rb_define_const(mColorspaceType, "RGB", INT2FIX(RGBColorspace));
    rb_define_const(mColorspaceType, "GRAY", INT2FIX(GRAYColorspace));
    rb_define_const(mColorspaceType, "Transparent", INT2FIX(TransparentColorspace));
    rb_define_const(mColorspaceType, "OHTA", INT2FIX(OHTAColorspace));
    rb_define_const(mColorspaceType, "XYZ", INT2FIX(XYZColorspace));
    rb_define_const(mColorspaceType, "YCbCr", INT2FIX(YCbCrColorspace));
    rb_define_const(mColorspaceType, "YCC", INT2FIX(YCCColorspace));
    rb_define_const(mColorspaceType, "YIQ", INT2FIX(YIQColorspace));
    rb_define_const(mColorspaceType, "YPbPr", INT2FIX(YPbPrColorspace));
    rb_define_const(mColorspaceType, "YUV", INT2FIX(YUVColorspace));
    rb_define_const(mColorspaceType, "CMYK", INT2FIX(CMYKColorspace));
    rb_define_const(mColorspaceType, "S_RGB", INT2FIX(sRGBColorspace));

    mCompositeOp = rb_define_module_under(mMagick, "CompositeOp");
    rb_define_const(mCompositeOp, "Undefined", INT2FIX(UndefinedCompositeOp));
    rb_define_const(mCompositeOp, "Over", INT2FIX(OverCompositeOp));
    rb_define_const(mCompositeOp, "In", INT2FIX(InCompositeOp));
    rb_define_const(mCompositeOp, "Out", INT2FIX(OutCompositeOp));
    rb_define_const(mCompositeOp, "Atop", INT2FIX(AtopCompositeOp));
    rb_define_const(mCompositeOp, "Xor", INT2FIX(XorCompositeOp));
    rb_define_const(mCompositeOp, "Plus", INT2FIX(PlusCompositeOp));
    rb_define_const(mCompositeOp, "Minus", INT2FIX(MinusCompositeOp));
    rb_define_const(mCompositeOp, "Add", INT2FIX(AddCompositeOp));
    rb_define_const(mCompositeOp, "Subtract", INT2FIX(SubtractCompositeOp));
    rb_define_const(mCompositeOp, "Difference", INT2FIX(DifferenceCompositeOp));
    rb_define_const(mCompositeOp, "Multiply", INT2FIX(MultiplyCompositeOp));
    rb_define_const(mCompositeOp, "Bumpmap", INT2FIX(BumpmapCompositeOp));
    rb_define_const(mCompositeOp, "Copy", INT2FIX(CopyCompositeOp));
    rb_define_const(mCompositeOp, "CopyRed", INT2FIX(CopyRedCompositeOp));
    rb_define_const(mCompositeOp, "CopyGreen", INT2FIX(CopyGreenCompositeOp));
    rb_define_const(mCompositeOp, "CopyBlue", INT2FIX(CopyBlueCompositeOp));
    rb_define_const(mCompositeOp, "CopyOpacity", INT2FIX(CopyOpacityCompositeOp));
    rb_define_const(mCompositeOp, "Clear", INT2FIX(ClearCompositeOp));
    rb_define_const(mCompositeOp, "Dissolve", INT2FIX(DissolveCompositeOp));
    rb_define_const(mCompositeOp, "Displace", INT2FIX(DisplaceCompositeOp));
    rb_define_const(mCompositeOp, "Modulate", INT2FIX(ModulateCompositeOp));
    rb_define_const(mCompositeOp, "Threshold", INT2FIX(ThresholdCompositeOp));

    mCompressionType = rb_define_module_under(mMagick, "CompressionType");
    rb_define_const(mCompressionType, "Undefined", INT2FIX(UndefinedCompression));
    rb_define_const(mCompressionType, "No", INT2FIX(NoCompression));
    rb_define_const(mCompressionType, "BZip", INT2FIX(BZipCompression));
    rb_define_const(mCompressionType, "Fax", INT2FIX(FaxCompression));
    rb_define_const(mCompressionType, "Group4", INT2FIX(Group4Compression));
    rb_define_const(mCompressionType, "JPEG", INT2FIX(JPEGCompression));
    rb_define_const(mCompressionType, "LosslessJPEG", INT2FIX(LosslessJPEGCompression));
    rb_define_const(mCompressionType, "RunlengthEncoded", INT2FIX(RunlengthEncodedCompression));
    rb_define_const(mCompressionType, "Zip", INT2FIX(ZipCompression));

    mDecorationType = rb_define_module_under(mMagick, "DecorationType");
    rb_define_const(mDecorationType, "No", INT2FIX(NoDecoration));
    rb_define_const(mDecorationType, "Underline", INT2FIX(UnderlineDecoration));
    rb_define_const(mDecorationType, "Overline", INT2FIX(OverlineDecoration));
    rb_define_const(mDecorationType, "LineThrough", INT2FIX(LineThroughDecoration));

    mFilterTypes = rb_define_module_under(mMagick, "FilterType");
    rb_define_const(mFilterTypes, "Undefined", INT2FIX(UndefinedFilter));
    rb_define_const(mFilterTypes, "Point", INT2FIX(PointFilter));
    rb_define_const(mFilterTypes, "BoxFilter", INT2FIX(BoxFilter));
    rb_define_const(mFilterTypes, "Triangle", INT2FIX(TriangleFilter));
    rb_define_const(mFilterTypes, "Hermite", INT2FIX(HermiteFilter));
    rb_define_const(mFilterTypes, "Hanning", INT2FIX(HanningFilter));
    rb_define_const(mFilterTypes, "Hamming", INT2FIX(HammingFilter));
    rb_define_const(mFilterTypes, "Blackman", INT2FIX(BlackmanFilter));
    rb_define_const(mFilterTypes, "Gaussian", INT2FIX(GaussianFilter));
    rb_define_const(mFilterTypes, "Quadratic", INT2FIX(QuadraticFilter));
    rb_define_const(mFilterTypes, "Cubic", INT2FIX(CubicFilter));
    rb_define_const(mFilterTypes, "Catrom", INT2FIX(CatromFilter));
    rb_define_const(mFilterTypes, "Mitchell", INT2FIX(MitchellFilter));
    rb_define_const(mFilterTypes, "Lanczos", INT2FIX(LanczosFilter));
    rb_define_const(mFilterTypes, "Bessel", INT2FIX(BesselFilter));
    rb_define_const(mFilterTypes, "Sinc", INT2FIX(SincFilter));

    mGravityType = rb_define_module_under(mMagick, "GravityType");
    rb_define_const(mGravityType, "Forget", INT2FIX(ForgetGravity));
    rb_define_const(mGravityType, "NorthWest", INT2FIX(NorthWestGravity));
    rb_define_const(mGravityType, "North", INT2FIX(NorthGravity));
    rb_define_const(mGravityType, "NorthEast", INT2FIX(NorthEastGravity));
    rb_define_const(mGravityType, "West", INT2FIX(WestGravity));
    rb_define_const(mGravityType, "Center", INT2FIX(CenterGravity));
    rb_define_const(mGravityType, "East", INT2FIX(EastGravity));
    rb_define_const(mGravityType, "SouthWest", INT2FIX(SouthWestGravity));
    rb_define_const(mGravityType, "South", INT2FIX(SouthGravity));
    rb_define_const(mGravityType, "SouthEast", INT2FIX(SouthEastGravity));
    rb_define_const(mGravityType, "Static", INT2FIX(StaticGravity));

    mInterlaceType = rb_define_module_under(mMagick, "InterlaceType");
    rb_define_const(mInterlaceType, "Undefined", INT2FIX(UndefinedInterlace));
    rb_define_const(mInterlaceType, "No", INT2FIX(NoInterlace));
    rb_define_const(mInterlaceType, "Line", INT2FIX(LineInterlace));
    rb_define_const(mInterlaceType, "Plane", INT2FIX(PlaneInterlace));
    rb_define_const(mInterlaceType, "Partition", INT2FIX(PartitionInterlace));

    mNoiseType = rb_define_module_under(mMagick, "NoiseType");
    rb_define_const(mNoiseType, "Uniform", INT2FIX(UniformNoise));
    rb_define_const(mNoiseType, "Gaussian", INT2FIX(GaussianNoise));
    rb_define_const(mNoiseType, "MultiplicativeGaussian", INT2FIX(MultiplicativeGaussianNoise));
    rb_define_const(mNoiseType, "Impulse", INT2FIX(ImpulseNoise));
    rb_define_const(mNoiseType, "Laplacian", INT2FIX(LaplacianNoise));
    rb_define_const(mNoiseType, "Poisson", INT2FIX(PoissonNoise));

    mPaintMethod = rb_define_module_under(mMagick, "PaintMethod");
    rb_define_const(mPaintMethod, "Point", INT2FIX(PointMethod));
    rb_define_const(mPaintMethod, "Replace", INT2FIX(ReplaceMethod));
    rb_define_const(mPaintMethod, "Floodfill", INT2FIX(FloodfillMethod));
    rb_define_const(mPaintMethod, "FillToBorder", INT2FIX(FillToBorderMethod));
    rb_define_const(mPaintMethod, "Reset", INT2FIX(ResetMethod));

    mPreviewType = rb_define_module_under(mMagick, "PreviewType");
    rb_define_const(mPreviewType, "Undefined", INT2FIX(UndefinedPreview));
    rb_define_const(mPreviewType, "Rotate", INT2FIX(RotatePreview));
    rb_define_const(mPreviewType, "Shear", INT2FIX(ShearPreview));
    rb_define_const(mPreviewType, "Roll", INT2FIX(RollPreview));
    rb_define_const(mPreviewType, "Hue",  INT2FIX(HuePreview));
    rb_define_const(mPreviewType, "Saturation", INT2FIX(SaturationPreview));
    rb_define_const(mPreviewType, "Brightness", INT2FIX(BrightnessPreview));
    rb_define_const(mPreviewType, "Gamma", INT2FIX(GammaPreview));
    rb_define_const(mPreviewType, "Spiff", INT2FIX(SpiffPreview));
    rb_define_const(mPreviewType, "Dull", INT2FIX(DullPreview));
    rb_define_const(mPreviewType, "Grayscale", INT2FIX(GrayscalePreview));
    rb_define_const(mPreviewType, "Quantize", INT2FIX(QuantizePreview));
    rb_define_const(mPreviewType, "Despeckle", INT2FIX(DespecklePreview));
    rb_define_const(mPreviewType, "ReduceNoise", INT2FIX(ReduceNoisePreview));
    rb_define_const(mPreviewType, "AddNoise", INT2FIX(AddNoisePreview));
    rb_define_const(mPreviewType, "Sharpen", INT2FIX(SharpenPreview));
    rb_define_const(mPreviewType, "Blur", INT2FIX(BlurPreview));
    rb_define_const(mPreviewType, "Threshold", INT2FIX(ThresholdPreview));
    rb_define_const(mPreviewType, "EdgeDetect", INT2FIX(EdgeDetectPreview));
    rb_define_const(mPreviewType, "Spread", INT2FIX(SpreadPreview));
    rb_define_const(mPreviewType, "Solarize", INT2FIX(SolarizePreview));
    rb_define_const(mPreviewType, "Shade", INT2FIX(ShadePreview));
    rb_define_const(mPreviewType, "Raise", INT2FIX(RaisePreview));
    rb_define_const(mPreviewType, "Segment", INT2FIX(SegmentPreview));
    rb_define_const(mPreviewType, "Swirl", INT2FIX(SwirlPreview));
    rb_define_const(mPreviewType, "Implode", INT2FIX(ImplodePreview));
    rb_define_const(mPreviewType, "Wave", INT2FIX(WavePreview));
    rb_define_const(mPreviewType, "OilPaint", INT2FIX(OilPaintPreview));
    rb_define_const(mPreviewType, "CharcoalDrawing", INT2FIX(CharcoalDrawingPreview));
    rb_define_const(mPreviewType, "JPEG", INT2FIX(JPEGPreview));


#if 0
    mQuantumType = rb_define_module_under(mMagick, "QuantumType");
    rb_define_const(mQuantumType, "Index", INT2FIX(IndexQuantum));
    rb_define_const(mQuantumType, "Gray", INT2FIX(GrayQuantum));
#if MagickLibVersion >= 0x0533
    rb_define_const(mQuantumType, "IndexAlpha", INT2FIX(IndexAlphaQuantum));
    rb_define_const(mQuantumType, "GrayAlpha", INT2FIX(GrayAlphaQuantum));
#else
    rb_define_const(mQuantumType, "IndexOpacity", INT2FIX(IndexOpacityQuantum));
    rb_define_const(mQuantumType, "GrayOpacity", INT2FIX(GrayOpacityQuantum));
#endif /* MagickLibVersion */
    rb_define_const(mQuantumType, "Red", INT2FIX(RedQuantum));
    rb_define_const(mQuantumType, "Cyan", INT2FIX(CyanQuantum));
    rb_define_const(mQuantumType, "Green", INT2FIX(GreenQuantum));
    rb_define_const(mQuantumType, "Yellow", INT2FIX(YellowQuantum));
    rb_define_const(mQuantumType, "Blue", INT2FIX(BlueQuantum));
    rb_define_const(mQuantumType, "Magenta", INT2FIX(MagentaQuantum));
#if MagickLibVersion >= 0x0533
    rb_define_const(mQuantumType, "Alpha", INT2FIX(AlphaQuantum));
#else
    rb_define_const(mQuantumType, "Opacity", INT2FIX(OpacityQuantum));
#endif /* MagickLibVersion */
    rb_define_const(mQuantumType, "Black", INT2FIX(BlackQuantum));
    rb_define_const(mQuantumType, "RGB", INT2FIX(RGBQuantum));
    rb_define_const(mQuantumType, "RGBA", INT2FIX(RGBAQuantum));
    rb_define_const(mQuantumType, "CMYK", INT2FIX(CMYKQuantum));
#endif /* 0 */

    mRenderingIntent = rb_define_module_under(mMagick, "RenderingIntent");
    rb_define_const(mRenderingIntent, "Undefined", INT2FIX(UndefinedIntent));
    rb_define_const(mRenderingIntent, "Saturation", INT2FIX(SaturationIntent));
    rb_define_const(mRenderingIntent, "Absolute", INT2FIX(AbsoluteIntent));
    rb_define_const(mRenderingIntent, "Relative", INT2FIX(RelativeIntent));

    mResolutionType = rb_define_module_under(mMagick, "ResolutionType");
    rb_define_const(mResolutionType, "Undefined", INT2FIX(UndefinedResolution));
    rb_define_const(mResolutionType, "PixelsPerInch", INT2FIX(PixelsPerInchResolution));
    rb_define_const(mResolutionType, "PixelsPerCentimeter", INT2FIX(PixelsPerCentimeterResolution));
}
