=begin

       extconf.rb

       option
       * --with-Magick-config=path : specify the location of Magick-config.

=end

def get_config(cmd, opts)
  ret = nil
  IO.popen(cmd + " " + opts) do |config_out|
    ret = config_out.gets.chop
  end
  ret
end

require "mkmf"
require "getoptlong"

parser = GetoptLong.new(['--with-Magick-config',GetoptLong::OPTIONAL_ARGUMENT])
alt_loc = nil
parser.each do |optname, value|
  alt_loc = if optname == '--with-Magick-config' then value; end
end

Magick_config = if !alt_loc or alt_loc.size==0 then "Magick-config" else alt_loc; end

Magick_VERSION  = get_config(Magick_config, "--version")
Magick_CFLAGS   = get_config(Magick_config, "--cflags")
Magick_CPPFLAGS = get_config(Magick_config, "--cppflags")
Magick_LDFLAGS  = get_config(Magick_config, "--ldflags")
Magick_LIBS     = get_config(Magick_config, "--libs")


$LDFLAGS += Magick_LDFLAGS + " " + Magick_LIBS
$CFLAGS  += Magick_CPPFLAGS + " " + Magick_CFLAGS + " -Wall"

if have_library("Magick")
  create_makefile("c_magick")
end
