=begin

  piddle.rb - drawing demo

=end

require "../lib/magick"

image = Magick::Image.new
image.set "size"=>"300x300"
image.read "xc:white"

# draw grid
0.step(300,10) do |i|
  line1 = Magick::Drawable::Line.new(image, i,0,i,300)
  line2 = Magick::Drawable::Line.new(image, 0,i,300,i)
  line1.set "stroke"=>"#ccf"
  line2.set "stroke"=>"#ccf"
  image.draw line1, line2
end

# create primitives

circ1 = Magick::Drawable::Circle.new(image,170,70,200,70)
circ1.set "stroke"=>"black","stroke_width"=>4, "fill"=>"yellow"

path = Magick::Drawable::Path.new(image,"M170,70 v-30 a30,30 0 0,0 -30,30 z")
path.set "stroke"=>"none","fill"=>"blue","stroke_width"=>4

round_rect = Magick::Drawable::RoundRectangle.new(image, 30,30,100,100,10,10)
round_rect.set "fill"=>"blue","stroke"=>"maroon","stroke_width"=>4

bezier = Magick::Drawable::Bezier.new(image,20,20,100,50,50,100,160,160)
bezier.set "fill"=>"none","stroke"=>"black","stroke_width"=>4

text = Magick::Drawable::Text.new(image, 30, 140, "This is a test!")
text.set "font"=>"Generic.ttf","fill"=>"green", "pointsize"=>24, "rotate"=>45.0

pentogram = Magick::Drawable::Polygon.new(image, 160,120,130,190,210,145,110,145,190,190,160,120)
pentogram.set "stroke"=>"red","fill"=>"LimeGreen","stroke_width"=>3

line1 = Magick::Drawable::Line.new(image, 200,260,200,200)
line2 = Magick::Drawable::Line.new(image, 200,200,260,200)
line3 = Magick::Drawable::Line.new(image, 260,200,260,260)
line4 = Magick::Drawable::Line.new(image, 200,260,260,260)

line1.set "stroke_width"=>5,"stroke"=>"yellow"
line2.set "stroke_width"=>5,"stroke"=>"yellow"
line3.set "stroke_width"=>5,"stroke"=>"red","dash_pattern"=>[2,4]
line4.set "stroke_width"=>5,"stroke"=>"green"

# draw all the primitives

image.draw circ1, path, round_rect, bezier, text,
           pentogram, line1, line2, line3, line4

image.write "filename"=>'piddle.gif'
image.display
