/* rsrce -- a Macintosh resource fork editor
 * Copyright (C) 2004  Jeremie Koenig
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "config.h"
#include "command.h"

char *filename;

int main(int argc, char **argv)
{
	const char *prompt;
	char buf[512], *c;
	FILE *f;

	filename = (argc > 1) ? argv[1] : NULL;
	if(filename) {
		f = strcmp(filename, "-") ? fopen(filename, "r") : stdin;
		if(!f) {
			perror(filename);
			exit(1);
		}
	} else
		f = NULL;
	
	cmd_init(f);
	prompt = isatty(0) ? CFG_PROMPT : "";
	
	while(fputs(prompt, stdout), fgets(buf, 512, stdin)) {
		c = strchr(buf, '\n');
		if(*c) *c = '\0';
		cmd_exec(buf);
	}
	if(isatty(0))
		printf("\n");
	return 0;
}


