/*
 * robrating.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares the RatingPlugin, which provides more detailed 
  * results than a simple "win, loss, tie"
  */
  
#ifndef __RT_RATING__
#define __RT_RATING__

#include "robfrontend.h"
#include "robmanage.h"
#include "robbase.h"

#include <rtsystem.h>

using namespace lrt;

namespace rt {

/// Rates the simulation result (for the first participating robot) and provides more detailed
/// information than just "win, loss or tie". 
/// The robot's success is displayed as a float value. 
class RatingPlugin : public FrontendPlugin  
{
public:
	virtual FpInterpretePos getInterpretePos();
	virtual String getName();
	virtual String getHelpText();
	virtual bool interpreteParams(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);
	RatingPlugin(Frontend* parent);
	~RatingPlugin() {}
private:
	int endCycles;
};

class RatingSimSupervisor : public SimSupervisor 
{
public:
	RatingSimSupervisor(int endCycles);
	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual GameState exec(Simulation* const curSim);
	virtual void exitSim(Simulation* const curSim, const GameState& simResult);
private:
	int endCycles;
	GameState retState;
};

} // namespace

#endif

