/*
 * robpackage.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Implements search path-related functions (looking for data files)
// that are most required when being installed as a RPM (or similar) package

#include "robpackage.h"

#include <rtsound.h>
#include <rtfile.h>
#include <rtresource.h>

using namespace lrt; 

namespace rt {

#ifdef EXTRA_DATA_DIR
	const char* extraDataDir = EXTRA_DATA_DIR;
#else
	const char* extraDataDir = ""; 
#endif

// Should be called at startup, after lrt was initialized!
void initPackage() 
{
#ifdef EXTRA_DATA_DIR
	Sound::addSoundFolder(String(extraDataDir) + "sounds/"); 

#endif
}

// Search for something everywhere
// xfolder: subfolder where to look
lrt::String findSomething(const lrt::String& xfolder, const lrt::String& file) 
{
	File execfolder = File::getExecutableFile().getParentFile();

	if(File(file).exists()) return file;

	if(File(execfolder, file).exists()) 
		return execfolder.getName() + file;
	if(File(execfolder, xfolder + file).exists()) 
		return execfolder.getName() + xfolder + file;


#ifdef EXTRA_DATA_DIR
	if(File(EXTRA_DATA_DIR + xfolder + file).exists())
		return EXTRA_DATA_DIR + xfolder + file; 
#endif

	return String(); 
}

// Search for an option set
lrt::String findOptionSet(const lrt::String& file)
{
	lrt::InputStream* is = lrt::Resource::getResource(file); 
	if(is) {
		delete is; 
		return file; // just the resource name
	}

	return findSomething("optsets/", file); 
}

// The sound finding is done by lrt::Sound itself. 
//lrt::String findSound(const lrt::String& baseName);

lrt::String findHelpFile(const lrt::String& file)
{
	return findSomething("help/", file); 
}



} // namespace
